/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.RuleUtils;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Date;

public class TLFreshnessCheck
extends ChainItem<XmlTLAnalysis> {
    private final XmlTrustedList currentTL;
    private final Date currentTime;
    private final TimeConstraint timeConstraint;

    public TLFreshnessCheck(I18nProvider i18nProvider, XmlTLAnalysis result, XmlTrustedList currentTL, Date currentTime, TimeConstraint timeConstraint) {
        super(i18nProvider, result, (LevelConstraint)timeConstraint);
        this.currentTL = currentTL;
        this.currentTime = currentTime;
        this.timeConstraint = timeConstraint;
    }

    @Override
    protected boolean process() {
        long maxFreshness = this.getMaxFreshness();
        long validationDateTime = this.currentTime.getTime();
        long limit = validationDateTime - maxFreshness;
        Date lastLoading = this.currentTL.getLastLoading();
        return lastLoading != null && lastLoading.after(new Date(limit));
    }

    private long getMaxFreshness() {
        return RuleUtils.convertDuration((TimeConstraint)this.timeConstraint);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_FRESH;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_TL_FRESH_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

