/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class BestSignatureTimeBeforeCertificateExpirationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;

    public BestSignatureTimeBeforeCertificateExpirationCheck(I18nProvider i18nProvider, T result, Date bestSignatureTime, CertificateWrapper signingCertificate, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.bestSignatureTime = bestSignatureTime;
        this.signingCertificate = signingCertificate;
    }

    @Override
    protected boolean process() {
        return this.bestSignatureTime.compareTo(this.signingCertificate.getNotAfter()) <= 0;
    }

    @Override
    protected String buildAdditionalInfo() {
        String bestSignatureTimeStr = this.bestSignatureTime == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.bestSignatureTime);
        String certNotAfter = this.signingCertificate.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.signingCertificate.getNotAfter());
        return this.i18nProvider.getMessage(MessageTag.BEST_SIGNATURE_TIME_CERT_NOT_AFTER, new Object[]{bestSignatureTimeStr, certNotAfter});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_IBSTBCEC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_IBSTBCEC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.OUT_OF_BOUNDS_NOT_REVOKED;
    }
}

