/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TimestampCoherenceOrderCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final List<TimestampWrapper> timestamps;

    public TimestampCoherenceOrderCheck(I18nProvider i18nProvider, XmlValidationProcessLongTermData result, List<TimestampWrapper> timestamps, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.timestamps = timestamps;
    }

    @Override
    protected boolean process() {
        return Utils.collectionSize(this.timestamps) <= 1 || this.checkTimestampCoherenceOrderByType();
    }

    private boolean checkTimestampCoherenceOrderByType() {
        ArrayList<TimestampWrapper> toBeCheckedTimestamps = new ArrayList<TimestampWrapper>(this.timestamps);
        Iterator tstIterator = toBeCheckedTimestamps.iterator();
        while (tstIterator.hasNext()) {
            TimestampWrapper timestamp = (TimestampWrapper)tstIterator.next();
            tstIterator.remove();
            if (this.isValidAgainstList(timestamp, toBeCheckedTimestamps)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidAgainstList(TimestampWrapper timestamp, List<TimestampWrapper> timestampList) {
        for (TimestampWrapper timestampToCompare : timestampList) {
            int typeResult = timestamp.getType().compare(timestampToCompare.getType());
            int productionTimeResult = timestamp.getProductionTime().compareTo(timestampToCompare.getProductionTime());
            if (productionTimeResult == 0 || typeResult == productionTimeResult) continue;
            if (typeResult == 0) {
                if (productionTimeResult < 0 && this.coversTheTimestamp(timestamp, timestampToCompare)) {
                    return false;
                }
                if (productionTimeResult <= 0 || !this.coversTheTimestamp(timestampToCompare, timestamp)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean coversTheTimestamp(TimestampWrapper timestamp, TimestampWrapper timestampToCompare) {
        return timestamp.getTimestampedTimestamps().contains(timestampToCompare);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_ASTPTCT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_ASTPTCT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TIMESTAMP_ORDER_FAILURE;
    }
}

