/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.impl.MojiCommand;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerFactory;
import fm.last.moji.tracker.impl.CommunicationException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private final TrackerFactory trackerFactory;
    private int maxAttempts;

    Executor(TrackerFactory trackerFactory) {
        this.trackerFactory = trackerFactory;
        this.maxAttempts = trackerFactory.getAddresses().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(MojiCommand command) throws IOException {
        Tracker tracker = null;
        CommunicationException lastException = null;
        for (int attempt = 0; attempt < this.maxAttempts; ++attempt) {
            try {
                tracker = this.trackerFactory.getTracker();
                log.debug("executing {}", (Object)command);
                if (this.maxAttempts > 1) {
                    log.debug("Attempt #{}", (Object)attempt);
                }
                command.executeWithTracker(tracker);
                return;
            }
            catch (CommunicationException e) {
                lastException = e;
                continue;
            }
            finally {
                if (tracker != null) {
                    tracker.close();
                }
            }
        }
        if (this.maxAttempts > 1) {
            log.debug("All {} attempts failed", (Object)this.maxAttempts);
        }
        throw lastException;
    }

    void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }
}

