/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.input.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileDownloadInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadInputStream.class);
    private final CountingInputStream delegate;
    private final Lock readLock;

    FileDownloadInputStream(InputStream delegate, Lock readLock) {
        this.readLock = readLock;
        this.delegate = new CountingInputStream(delegate);
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        log.debug("Read {} bytes", (Object)this.delegate.getByteCount());
        try {
            this.delegate.close();
        }
        finally {
            this.unlockQuietly(this.readLock);
        }
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    private void unlockQuietly(Lock lock) {
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }
}

