/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.impl.MojiCommand;
import fm.last.moji.tracker.Tracker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileLengthCommand
implements MojiCommand {
    private static final Logger log = LoggerFactory.getLogger(FileLengthCommand.class);
    private final HttpConnectionFactory httpFactory;
    final String key;
    final String domain;
    private long length = -1L;

    FileLengthCommand(HttpConnectionFactory httpFactory, String key, String domain) {
        this.httpFactory = httpFactory;
        this.key = key;
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeWithTracker(Tracker tracker) throws IOException {
        List<URL> paths = tracker.getPaths(this.key, this.domain);
        if (!paths.isEmpty()) {
            HttpURLConnection httpConnection = null;
            IOException lastException = null;
            for (URL path : paths) {
                try {
                    log.debug("HTTP HEAD -> {}", (Object)path);
                    httpConnection = this.httpFactory.newConnection(path);
                    httpConnection.setRequestMethod("HEAD");
                    this.length = this.getContentLength(httpConnection);
                    log.debug("Content-Length: {}", (Object)this.length);
                    return;
                }
                catch (IOException e) {
                    log.debug("Failed to open input -> {}", (Object)path);
                    log.debug("Exception was: ", (Throwable)e);
                    lastException = e;
                }
                finally {
                    if (httpConnection == null) continue;
                    httpConnection.disconnect();
                }
            }
            throw lastException;
        }
        log.debug("No paths found for domain={},key={} - throwing", (Object)this.domain, (Object)this.key);
        throw new FileNotFoundException("domain=" + this.domain + ",key=" + this.key);
    }

    long getLength() {
        return this.length;
    }

    String getKey() {
        return this.key;
    }

    String getDomain() {
        return this.domain;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileLengthCommand [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }

    private long getContentLength(HttpURLConnection httpConnection) {
        long length = 0L;
        String rawLength = httpConnection.getHeaderField("Content-Length");
        if (rawLength == null) {
            log.debug("No Content-Length header found, assume the length is 0");
            return 0L;
        }
        try {
            length = Long.parseLong(rawLength);
        }
        catch (NumberFormatException e) {
            log.debug("Failed to parse Content-Length: {}", (Object)rawLength);
            length = -1L;
        }
        return length;
    }
}

