/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.tracker.Destination;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.TrackerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.output.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileUploadOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(FileUploadOutputStream.class);
    private static final int CHUNK_LENGTH = 4096;
    private final Destination destination;
    private final TrackerFactory trackerFactory;
    private final String key;
    private final String domain;
    private final Lock writeLock;
    private final HttpURLConnection httpConnection;
    private final CountingOutputStream delegate;
    private long size = -1L;

    FileUploadOutputStream(TrackerFactory trackerFactory, HttpConnectionFactory httpFactory, String key, String domain, Destination destination, Lock writeLock) throws IOException {
        this.destination = destination;
        this.trackerFactory = trackerFactory;
        this.domain = domain;
        this.key = key;
        this.writeLock = writeLock;
        log.debug("HTTP PUT -> opening chunked stream -> {}", (Object)destination.getPath());
        this.httpConnection = httpFactory.newConnection(destination.getPath());
        this.httpConnection.setRequestMethod("PUT");
        this.httpConnection.setChunkedStreamingMode(4096);
        this.httpConnection.setDoOutput(true);
        this.delegate = new CountingOutputStream(this.httpConnection.getOutputStream());
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        log.debug("Close called on {}", (Object)this);
        try {
            this.flushAndClose();
            this.trackerCreateClose();
        }
        finally {
            this.unlockQuietly(this.writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackerCreateClose() throws TrackerException {
        int maxAttempts = 2;
        TrackerException lastException = null;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            Tracker tracker = null;
            try {
                tracker = this.trackerFactory.getTracker();
                tracker.createClose(this.key, this.domain, this.destination, this.size);
                return;
            }
            catch (TrackerException e) {
                lastException = e;
                log.warn("create_close attempt {} failed", (Object)(attempt + 1), (Object)e);
                continue;
            }
            finally {
                if (tracker != null) {
                    tracker.close();
                }
            }
        }
        log.error("All {} attempts to create_close failed", (Object)maxAttempts);
        throw lastException;
    }

    private void flushAndClose() throws IOException {
        try {
            this.delegate.flush();
            this.size = this.delegate.getByteCount();
            log.debug("Bytes written: {}", (Object)this.size);
            int code = this.httpConnection.getResponseCode();
            if (200 != code && 201 != code) {
                String message = this.httpConnection.getResponseMessage();
                throw new IOException("HTTP Error during flush: " + code + ", " + message + ", peer: '{" + this.httpConnection + "}'");
            }
        }
        finally {
            try {
                this.delegate.close();
            }
            catch (Exception e) {
                log.warn("Error closing stream", (Throwable)e);
            }
            try {
                this.httpConnection.disconnect();
            }
            catch (Exception e) {
                log.warn("Error closing connection", (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileUploadOutputStream [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append("]");
        return builder.toString();
    }

    private void unlockQuietly(Lock lock) {
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }
}

