/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.MojiDeviceStatus;
import fm.last.moji.impl.MojiCommand;
import fm.last.moji.impl.MojiDeviceStatusImpl;
import fm.last.moji.tracker.Tracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class GetDeviceStatusesCommand
implements MojiCommand {
    private final String domain;
    private List<MojiDeviceStatus> deviceStatuses;

    GetDeviceStatusesCommand(String domain) {
        this.domain = domain;
        this.deviceStatuses = Collections.emptyList();
    }

    @Override
    public void executeWithTracker(Tracker tracker) throws IOException {
        Map<String, Map<String, String>> parametersByDevice = tracker.getDeviceStatuses(this.domain);
        ArrayList<MojiDeviceStatusImpl> statuses = new ArrayList<MojiDeviceStatusImpl>(parametersByDevice.size());
        for (Map.Entry<String, Map<String, String>> deviceParameters : parametersByDevice.entrySet()) {
            statuses.add(new MojiDeviceStatusImpl(deviceParameters.getKey(), deviceParameters.getValue()));
        }
        this.deviceStatuses = Collections.unmodifiableList(statuses);
    }

    List<MojiDeviceStatus> getStatuses() {
        return this.deviceStatuses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [domain=");
        builder.append(this.domain);
        builder.append(", deviceStatuses=");
        builder.append(this.deviceStatuses);
        builder.append("]");
        return builder.toString();
    }
}

