/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.impl.FileDownloadInputStream;
import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.impl.MojiCommand;
import fm.last.moji.tracker.Tracker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetInputStreamCommand
implements MojiCommand {
    private static final Logger log = LoggerFactory.getLogger(GetInputStreamCommand.class);
    final String key;
    final String domain;
    private final HttpConnectionFactory httpFactory;
    private final Lock readLock;
    private InputStream stream;

    GetInputStreamCommand(String key, String domain, HttpConnectionFactory httpFactory, Lock readLock) {
        this.key = key;
        this.domain = domain;
        this.httpFactory = httpFactory;
        this.readLock = readLock;
    }

    @Override
    public void executeWithTracker(Tracker tracker) throws IOException {
        List<URL> paths = tracker.getPaths(this.key, this.domain);
        if (paths.isEmpty()) {
            throw new FileNotFoundException("key=" + this.key + ", domain=" + this.domain);
        }
        IOException lastException = null;
        for (URL path : paths) {
            try {
                log.debug("Opened: {}", (Object)path);
                HttpURLConnection urlConnection = this.httpFactory.newConnection(path);
                this.stream = new FileDownloadInputStream(urlConnection.getInputStream(), this.readLock);
                return;
            }
            catch (IOException e) {
                log.debug("Failed to open input -> {}", (Object)path);
                log.debug("Exception was: ", (Throwable)e);
                lastException = e;
                IOUtils.closeQuietly((InputStream)this.stream);
            }
        }
        throw lastException;
    }

    InputStream getInputStream() {
        return this.stream;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetInputStreamCommand [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append("]");
        return builder.toString();
    }
}

