/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.impl.FileUploadOutputStream;
import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.impl.MojiCommand;
import fm.last.moji.tracker.Destination;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.TrackerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetOutputStreamCommand
implements MojiCommand {
    private static final Logger log = LoggerFactory.getLogger(GetOutputStreamCommand.class);
    final String key;
    final String domain;
    final String storageClass;
    private final TrackerFactory trackerFactory;
    private final HttpConnectionFactory httpFactory;
    private OutputStream stream;
    private final Lock writeLock;

    GetOutputStreamCommand(TrackerFactory trackerFactory, HttpConnectionFactory httpFactory, String key, String domain, String storageClass, Lock writeLock) {
        this.trackerFactory = trackerFactory;
        this.httpFactory = httpFactory;
        this.key = key;
        this.domain = domain;
        this.storageClass = storageClass;
        this.writeLock = writeLock;
    }

    @Override
    public void executeWithTracker(Tracker tracker) throws IOException {
        List<Destination> destinations = tracker.createOpen(this.key, this.domain, this.storageClass);
        if (destinations.isEmpty()) {
            throw new TrackerException("Failed to obtain destinations for domain=" + this.domain + ",key=" + this.key + ",storageClass=" + this.storageClass);
        }
        IOException lastException = null;
        for (Destination destination : destinations) {
            log.debug("Creating output stream to: {}", (Object)destination);
            try {
                this.stream = new FileUploadOutputStream(this.trackerFactory, this.httpFactory, this.key, this.domain, destination, this.writeLock);
                return;
            }
            catch (IOException e) {
                log.debug("Failed to open output -> {}", (Object)destination);
                log.debug("Exception was: ", (Throwable)e);
                lastException = e;
                IOUtils.closeQuietly((OutputStream)this.stream);
            }
        }
        throw lastException;
    }

    OutputStream getOutputStream() {
        return this.stream;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetOutputStreamCommand [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", storageClass=");
        builder.append(this.storageClass);
        builder.append("]");
        return builder.toString();
    }
}

