/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.Moji;
import fm.last.moji.MojiFile;
import fm.last.moji.impl.MojiCommand;
import fm.last.moji.tracker.Tracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ListFilesCommand
implements MojiCommand {
    final String keyPrefix;
    final String domain;
    final Integer limit;
    private List<MojiFile> files;
    private final Moji moji;

    ListFilesCommand(Moji moji, String keyPrefix, String domain, int limit) {
        this(moji, keyPrefix, domain, (Integer)limit);
    }

    ListFilesCommand(Moji moji, String keyPrefix, String domain) {
        this(moji, keyPrefix, domain, null);
    }

    private ListFilesCommand(Moji moji, String keyPrefix, String domain, Integer limit) {
        this.moji = moji;
        this.keyPrefix = keyPrefix;
        this.domain = domain;
        this.limit = limit;
        this.files = Collections.emptyList();
    }

    @Override
    public void executeWithTracker(Tracker tracker) throws IOException {
        List<String> keys = tracker.list(this.domain, this.keyPrefix, this.limit);
        if (!keys.isEmpty()) {
            this.files = new ArrayList<MojiFile>(keys.size());
            for (String key : keys) {
                MojiFile file = this.moji.getFile(key);
                this.files.add(file);
            }
        }
    }

    List<MojiFile> getFileList() {
        return this.files;
    }
}

