/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.commons.lang.units.IecByteUnit;
import fm.last.moji.MojiDeviceStatus;
import fm.last.moji.impl.DeviceStatusField;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MojiDeviceStatusImpl
implements MojiDeviceStatus {
    private static final Logger log = LoggerFactory.getLogger(MojiDeviceStatusImpl.class);
    private final Map<String, String> valueMap;
    private final String deviceName;

    MojiDeviceStatusImpl(String deviceName, Map<String, String> valueMap) {
        this.deviceName = deviceName;
        this.valueMap = valueMap;
    }

    @Override
    public Float getUtilization() {
        return (Float)this.getValue(DeviceStatusField.UTILIZATION);
    }

    @Override
    public String getObservedState() {
        return (String)this.getValue(DeviceStatusField.OBSERVED_STATE);
    }

    @Override
    public Boolean getRejectBadMd5() {
        return (Boolean)this.getValue(DeviceStatusField.REJECT_BAD_MD5);
    }

    @Override
    public Long getCapacityUsedBytes() {
        Long used = (Long)this.getValue(DeviceStatusField.CAPACITY_USED);
        if (used == null) {
            return null;
        }
        return IecByteUnit.MEBIBYTES.toBytes(used.longValue());
    }

    @Override
    public Long getCapacityFreeBytes() {
        Long free = (Long)this.getValue(DeviceStatusField.CAPACITY_FREE);
        if (free == null) {
            return null;
        }
        return IecByteUnit.MEBIBYTES.toBytes(free.longValue());
    }

    @Override
    public Long getCapacityTotalBytes() {
        Long total = (Long)this.getValue(DeviceStatusField.CAPACITY_TOTAL);
        if (total == null) {
            return null;
        }
        return IecByteUnit.MEBIBYTES.toBytes(total.longValue());
    }

    @Override
    public Integer getWeight() {
        return (Integer)this.getValue(DeviceStatusField.WEIGHT);
    }

    @Override
    public Integer getId() {
        return (Integer)this.getValue(DeviceStatusField.DEVICE_ID);
    }

    @Override
    public String getStatus() {
        return (String)this.getValue(DeviceStatusField.STATUS);
    }

    @Override
    public Integer getHostId() {
        return (Integer)this.getValue(DeviceStatusField.HOST_ID);
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.deviceName);
        builder.append('[');
        boolean first = true;
        for (DeviceStatusField field : DeviceStatusField.values()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append((Object)field);
            builder.append('=');
            builder.append(this.getValue(field));
        }
        builder.append(']');
        return builder.toString();
    }

    private Object getValue(DeviceStatusField field) {
        String value = this.valueMap.get(field.getFieldName());
        if (value == null) {
            log.debug("Field " + (Object)((Object)field) + " not present in status response.");
            return null;
        }
        Class<?> destinationType = field.getDestinationType();
        try {
            if (destinationType == String.class) {
                return value;
            }
            if (destinationType == Float.class) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (destinationType == Long.class) {
                return Long.parseLong(value);
            }
            if (destinationType == Integer.class) {
                return Integer.parseInt(value);
            }
            if (destinationType == Boolean.class) {
                return Integer.parseInt(value) > 0;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Could not convert " + (Object)((Object)field) + " field value to " + destinationType + ": " + value, (Throwable)e);
        }
        throw new IllegalStateException("Unknown conversion type " + destinationType + " for field: " + (Object)((Object)field));
    }
}

