/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.MojiFile;
import fm.last.moji.MojiFileAttributes;
import fm.last.moji.impl.DeleteCommand;
import fm.last.moji.impl.Executor;
import fm.last.moji.impl.ExistsCommand;
import fm.last.moji.impl.FileLengthCommand;
import fm.last.moji.impl.GetAttributesCommand;
import fm.last.moji.impl.GetInputStreamCommand;
import fm.last.moji.impl.GetOutputStreamCommand;
import fm.last.moji.impl.GetPathsCommand;
import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.impl.RenameCommand;
import fm.last.moji.impl.UpdateStorageClassCommand;
import fm.last.moji.tracker.TrackerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MojiFileImpl
implements MojiFile {
    private static final Logger log = LoggerFactory.getLogger(MojiFileImpl.class);
    private final String domain;
    private final TrackerFactory trackerFactory;
    private final HttpConnectionFactory httpFactory;
    private final ReadWriteLock lock;
    private Executor executor;
    private String storageClass;
    private String key;

    MojiFileImpl(String key, String domain, String storageClass, TrackerFactory trackerFactory, HttpConnectionFactory httpFactory) {
        this.key = key;
        this.domain = domain;
        this.storageClass = storageClass;
        this.trackerFactory = trackerFactory;
        this.httpFactory = httpFactory;
        this.executor = new Executor(trackerFactory);
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean exists() throws IOException {
        log.debug("exists() : {}", (Object)this);
        boolean exists = false;
        try {
            this.lock.readLock().lock();
            ExistsCommand command = new ExistsCommand(this.key, this.domain);
            this.executor.executeCommand(command);
            exists = command.getExists();
            log.debug("exists() -> {}", (Object)exists);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return exists;
    }

    @Override
    public void delete() throws IOException {
        log.debug("delete() : {}", (Object)this);
        try {
            this.lock.writeLock().lock();
            DeleteCommand command = new DeleteCommand(this.key, this.domain);
            this.executor.executeCommand(command);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws IOException {
        log.debug("length() : {}", (Object)this);
        long length = -1L;
        try {
            this.lock.readLock().lock();
            FileLengthCommand command = new FileLengthCommand(this.httpFactory, this.key, this.domain);
            this.executor.executeCommand(command);
            length = command.getLength();
            log.debug("length() -> {}", (Object)length);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        log.debug("getInputStream() : {}", (Object)this);
        InputStream inputStream = null;
        try {
            Lock readLock = this.lock.readLock();
            readLock.lock();
            GetInputStreamCommand command = new GetInputStreamCommand(this.key, this.domain, this.httpFactory, readLock);
            this.executor.executeCommand(command);
            inputStream = command.getInputStream();
            log.debug("getInputStream() -> {}", (Object)inputStream);
        }
        catch (Throwable e) {
            this.unlockQuietly(this.lock.readLock());
            IOUtils.closeQuietly(inputStream);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        return inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        log.debug("getOutputStream() : {}", (Object)this);
        OutputStream outputStream = null;
        try {
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            GetOutputStreamCommand command = new GetOutputStreamCommand(this.trackerFactory, this.httpFactory, this.key, this.domain, this.storageClass, writeLock);
            this.executor.executeCommand(command);
            outputStream = command.getOutputStream();
            log.debug("getOutputStream() -> {}", (Object)outputStream);
        }
        catch (Throwable e) {
            this.unlockQuietly(this.lock.writeLock());
            IOUtils.closeQuietly(outputStream);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        return outputStream;
    }

    @Override
    public void rename(String newKey) throws IOException {
        log.debug("rename() : {}", (Object)this);
        try {
            this.lock.writeLock().lock();
            RenameCommand command = new RenameCommand(this.key, this.domain, newKey);
            this.executor.executeCommand(command);
            this.key = newKey;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void modifyStorageClass(String newStorageClass) throws IOException {
        log.debug("setStorageClass() : {}", (Object)this);
        if (this.storageClass == null) {
            throw new IllegalArgumentException("storageClass == null");
        }
        try {
            this.lock.writeLock().lock();
            UpdateStorageClassCommand command = new UpdateStorageClassCommand(this.key, this.domain, newStorageClass);
            this.executor.executeCommand(command);
            this.storageClass = newStorageClass;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<URL> getPaths() throws IOException {
        log.debug("getPaths() : {}", (Object)this);
        List<URL> paths = Collections.emptyList();
        try {
            this.lock.readLock().lock();
            GetPathsCommand command = new GetPathsCommand(this.key, this.domain);
            this.executor.executeCommand(command);
            paths = command.getPaths();
            log.debug("getPaths() -> {}", paths);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return paths;
    }

    @Override
    public MojiFileAttributes getAttributes() throws IOException {
        log.debug("getAttributes() : {}", (Object)this);
        MojiFileAttributes attributes = null;
        try {
            this.lock.readLock().lock();
            GetAttributesCommand command = new GetAttributesCommand(this.key, this.domain);
            this.executor.executeCommand(command);
            attributes = command.getAttributes();
            log.debug("getAttributes() -> {}", (Object)attributes);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return attributes;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MogileFileImpl [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void copyToFile(File destination) throws IOException {
        InputStream inputStream = null;
        inputStream = this.getInputStream();
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)destination);
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private void unlockQuietly(Lock lock) {
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }
}

