/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.Moji;
import fm.last.moji.MojiDeviceStatus;
import fm.last.moji.MojiFile;
import fm.last.moji.impl.Executor;
import fm.last.moji.impl.GetDeviceStatusesCommand;
import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.impl.ListFilesCommand;
import fm.last.moji.impl.MojiFileImpl;
import fm.last.moji.tracker.TrackerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MojiImpl
implements Moji {
    private static final Logger log = LoggerFactory.getLogger(MojiImpl.class);
    private final TrackerFactory trackerFactory;
    private final HttpConnectionFactory httpFactory;
    private final String domain;
    private final Executor executor;

    MojiImpl(TrackerFactory trackerFactory, HttpConnectionFactory httpFactory, String domain) {
        this.domain = domain;
        this.httpFactory = httpFactory;
        this.trackerFactory = trackerFactory;
        this.executor = new Executor(trackerFactory);
    }

    @Override
    public MojiFile getFile(String key) {
        log.debug("new {}()", (Object)MojiFileImpl.class.getSimpleName());
        return new MojiFileImpl(key, this.domain, "", this.trackerFactory, this.httpFactory);
    }

    @Override
    public MojiFile getFile(String key, String storageClass) {
        if (storageClass == null) {
            throw new IllegalArgumentException("storageClass == null");
        }
        log.debug("new {}() with storage class", (Object)MojiFileImpl.class.getSimpleName());
        return new MojiFileImpl(key, this.domain, storageClass, this.trackerFactory, this.httpFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyToMogile(File source, MojiFile destination) throws IOException {
        OutputStream outputStream = null;
        FileInputStream inputStream = new FileInputStream(source);
        try {
            outputStream = destination.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    @Override
    public List<MojiFile> list(String keyPrefix) throws IOException {
        log.debug("list() : {}", (Object)keyPrefix);
        List<MojiFile> list = null;
        ListFilesCommand command = new ListFilesCommand(this, keyPrefix, this.domain);
        this.executor.executeCommand(command);
        list = command.getFileList();
        log.debug("list() -> {}", list);
        return list;
    }

    @Override
    public List<MojiFile> list(String keyPrefix, int limit) throws IOException {
        log.debug("list() : {}, {}", (Object)keyPrefix, (Object)limit);
        List<MojiFile> list = null;
        ListFilesCommand command = new ListFilesCommand((Moji)this, keyPrefix, this.domain, limit);
        this.executor.executeCommand(command);
        list = command.getFileList();
        log.debug("list() -> {}", list);
        return list;
    }

    @Override
    public List<MojiDeviceStatus> getDeviceStatuses() throws IOException {
        log.debug("getDevicesStatus : {}", (Object)this);
        GetDeviceStatusesCommand command = new GetDeviceStatusesCommand(this.domain);
        this.executor.executeCommand(command);
        List<MojiDeviceStatus> statuses = command.getStatuses();
        log.debug("getDevicesStatus() -> {}", statuses);
        return statuses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MojiImpl [domain=");
        builder.append(this.domain);
        builder.append(", trackerFactory=");
        builder.append(this.trackerFactory);
        builder.append("]");
        return builder.toString();
    }
}

