/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.impl;

import fm.last.moji.Moji;
import fm.last.moji.MojiFactory;
import fm.last.moji.impl.HttpConnectionFactory;
import fm.last.moji.impl.MojiImpl;
import fm.last.moji.impl.NetworkingConfiguration;
import fm.last.moji.tracker.TrackerFactory;
import fm.last.moji.tracker.impl.InetSocketAddressFactory;
import fm.last.moji.tracker.pool.MultiHostTrackerPool;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class PropertyMojiFactory
implements MojiFactory {
    public static final String RESOURCE_PATH_PROPERTY = "moji.properties.resource.path";
    private static final String DEFAULT_RESOURCE_PATH = "/moji.properties";
    private static final String HOSTS_PROPERTY = "moji.tracker.hosts";
    private static final String DOMAIN_PROPERTY = "moji.domain";
    private static final String TRACKER_CONNECT_T_O_PROPERTY = "moji.tracker.connect.timeout";
    private static final String TRACKER_READ_T_O_PROPERTY = "moji.tracker.so.timeout";
    private static final String HTTP_CONNECT_T_O_PROPERTY = "moji.http.connect.timeout";
    private static final String HTTP_READ_T_O_PROPERTY = "moji.http.read.timeout";
    private final NetworkingConfiguration netConfig;
    private volatile boolean initialised;
    private String defaultDomain;
    private TrackerFactory trackerFactory;
    private HttpConnectionFactory httpFactory;
    private final String propertiesPath;

    public PropertyMojiFactory(String propertiesPath, Proxy proxy) throws IOException {
        this.propertiesPath = System.getProperty(RESOURCE_PATH_PROPERTY, propertiesPath);
        this.netConfig = new NetworkingConfiguration.Builder().proxy(proxy).build();
    }

    public PropertyMojiFactory(String propertiesPath) throws IOException {
        this(propertiesPath, Proxy.NO_PROXY);
    }

    public PropertyMojiFactory(Proxy proxy) throws IOException {
        this(DEFAULT_RESOURCE_PATH, proxy);
    }

    public PropertyMojiFactory() throws IOException {
        this(DEFAULT_RESOURCE_PATH, Proxy.NO_PROXY);
    }

    @Override
    public Moji getInstance() throws IOException {
        this.initialise();
        return new MojiImpl(this.trackerFactory, this.httpFactory, this.defaultDomain);
    }

    @Override
    public Moji getInstance(String domain) throws IOException {
        this.initialise();
        return new MojiImpl(this.trackerFactory, this.httpFactory, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise() throws IOException {
        PropertyMojiFactory propertyMojiFactory = this;
        synchronized (propertyMojiFactory) {
            if (!this.initialised) {
                Properties properties = this.loadProperties();
                String addressesCsv = this.getHosts(properties);
                this.defaultDomain = this.getDomain(properties);
                Set<InetSocketAddress> addresses = InetSocketAddressFactory.newAddresses(addressesCsv);
                this.netConfig.setHttpConnectTimeout(this.getTimeout(HTTP_CONNECT_T_O_PROPERTY, properties));
                this.netConfig.setHttpReadTimeout(this.getTimeout(HTTP_READ_T_O_PROPERTY, properties));
                this.netConfig.setTrackerConnectTimeout(this.getTimeout(TRACKER_CONNECT_T_O_PROPERTY, properties));
                this.netConfig.setTrackerReadTimeout(this.getTimeout(TRACKER_READ_T_O_PROPERTY, properties));
                this.trackerFactory = new MultiHostTrackerPool(addresses, this.netConfig);
                this.httpFactory = new HttpConnectionFactory(this.trackerFactory.getNetworkingConfiguration());
                this.initialised = true;
            }
        }
    }

    private Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        InputStream stream = this.getClass().getResourceAsStream(this.propertiesPath);
        try {
            properties.load(stream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return properties;
    }

    private String getDomain(Properties properties) {
        String domain = properties.getProperty(DOMAIN_PROPERTY);
        if (domain == null || domain.isEmpty()) {
            throw new IllegalStateException("moji.domain cannot be empty or null");
        }
        return domain;
    }

    private String getHosts(Properties properties) {
        String host = properties.getProperty(HOSTS_PROPERTY);
        if (host == null || host.isEmpty()) {
            throw new IllegalStateException("moji.tracker.hosts cannot be empty or null");
        }
        return host;
    }

    private int getTimeout(String propertyName, Properties properties) {
        int timeout = 0;
        try {
            timeout = Integer.parseInt(properties.getProperty(propertyName, "0"));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(propertyName + " must be an integer.");
        }
        return timeout;
    }
}

