/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.local;

import fm.last.moji.local.LocalFileNamingStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

class Base64FileNamingStrategy
implements LocalFileNamingStrategy {
    private static final String UTF_8 = "UTF-8";
    private final File baseFolder;

    Base64FileNamingStrategy(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    @Override
    public String newFileName(String domain, String key, String storageClass) {
        Base64 base64 = new Base64(-1);
        String name = this.encode(base64, domain) + "-" + this.encode(base64, key) + "-" + this.encode(base64, storageClass) + ".dat";
        return name;
    }

    @Override
    public String domainForFileName(String fileName) {
        String encodedDomain = fileName.split("[-\\.]")[0];
        Base64 base64 = new Base64(-1);
        String domain = this.decode(base64, encodedDomain);
        return domain;
    }

    @Override
    public String keyForFileName(String fileName) {
        String encodedKey = fileName.split("[-\\.]")[1];
        Base64 base64 = new Base64(-1);
        String key = this.decode(base64, encodedKey);
        return key;
    }

    @Override
    public String storageClassForFileName(String fileName) {
        String encodedStorageClass = fileName.split("[-\\.]")[2];
        Base64 base64 = new Base64(-1);
        String storageClass = this.decode(base64, encodedStorageClass);
        return storageClass;
    }

    @Override
    public File folderForDomain(String domain) {
        return this.baseFolder;
    }

    @Override
    public FilenameFilter filterForPrefix(String domain, String keyPrefix) {
        return new KeyPrefixFileNameFilter(domain, keyPrefix);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Base64FileNamingStrategy [baseFolder=");
        builder.append(this.baseFolder);
        builder.append("]");
        return builder.toString();
    }

    private String encode(Base64 base64, String string) {
        try {
            return base64.encodeAsString(string.getBytes(UTF_8)).replace('\\', '|');
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String decode(Base64 base64, String string) {
        try {
            return new String(base64.decode(string.replace('|', '\\').getBytes(UTF_8)), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private final class KeyPrefixFileNameFilter
    implements FilenameFilter {
        private final String keyPrefix;
        private final String encodedDomain;
        private final Base64 base64 = new Base64(-1);

        private KeyPrefixFileNameFilter(String domain, String keyPrefix) {
            this.encodedDomain = Base64FileNamingStrategy.this.encode(this.base64, domain);
            this.keyPrefix = keyPrefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!Base64FileNamingStrategy.this.baseFolder.equals(dir)) {
                return false;
            }
            if (name.startsWith(".")) {
                return false;
            }
            if (!name.startsWith(this.encodedDomain + "-")) {
                return false;
            }
            String key = Base64FileNamingStrategy.this.keyForFileName(name);
            return key.startsWith(this.keyPrefix);
        }
    }
}

