/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.local;

import fm.last.moji.Moji;
import fm.last.moji.MojiDeviceStatus;
import fm.last.moji.MojiFile;
import fm.last.moji.local.Base64FileNamingStrategy;
import fm.last.moji.local.LocalFileNamingStrategy;
import fm.last.moji.local.LocalMojiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class LocalFileSystemMoji
implements Moji {
    private final File baseFolder;
    private final LocalFileNamingStrategy namingStrategy;
    private final String domain;

    public LocalFileSystemMoji(File baseFolder, String domain) {
        this(baseFolder, domain, new Base64FileNamingStrategy(baseFolder));
    }

    public LocalFileSystemMoji(File baseFolder, String domain, LocalFileNamingStrategy namingStrategy) {
        this.createBaseFolderIfNeeded(baseFolder);
        this.baseFolder = baseFolder;
        this.domain = domain;
        this.namingStrategy = namingStrategy;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public LocalFileNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public MojiFile getFile(String key) {
        return new LocalMojiFile(this.namingStrategy, this.baseFolder, this.domain, key);
    }

    @Override
    public MojiFile getFile(String key, String storageClass) {
        return new LocalMojiFile(this.namingStrategy, this.baseFolder, this.domain, key, storageClass);
    }

    @Override
    public void copyToMogile(File source, MojiFile destination) throws IOException {
        LocalMojiFile localDestination = (LocalMojiFile)destination;
        FileUtils.copyFile((File)source, (File)localDestination.file);
    }

    @Override
    public List<MojiFile> list(String keyPrefix) {
        File[] files = this.baseFolder.listFiles(this.namingStrategy.filterForPrefix(this.domain, keyPrefix));
        ArrayList<MojiFile> mojiFiles = new ArrayList<MojiFile>(files.length);
        for (File file : files) {
            String key = this.namingStrategy.keyForFileName(file.getName());
            String storageClass = this.namingStrategy.storageClassForFileName(file.getName());
            mojiFiles.add(new LocalMojiFile(this.namingStrategy, this.baseFolder, this.domain, key, storageClass));
        }
        return mojiFiles;
    }

    @Override
    public List<MojiFile> list(String keyPrefix, int limit) {
        List<MojiFile> list = this.list(keyPrefix);
        int count = limit > list.size() ? list.size() : limit;
        ArrayList<MojiFile> mojiFiles = new ArrayList<MojiFile>();
        for (int i = 0; i < count; ++i) {
            mojiFiles.add(list.get(i));
        }
        return mojiFiles;
    }

    @Override
    public List<MojiDeviceStatus> getDeviceStatuses() {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalFileSystemMoji [baseFolder=");
        builder.append(this.baseFolder);
        builder.append(", domain=");
        builder.append(this.domain);
        builder.append(", namingStrategy=");
        builder.append(this.namingStrategy);
        builder.append("]");
        return builder.toString();
    }

    private void createBaseFolderIfNeeded(File baseFolder) {
        boolean mkdirs;
        boolean exists = baseFolder.exists();
        if (!exists && !(mkdirs = baseFolder.mkdirs())) {
            throw new IllegalStateException("Could not create base directory: " + baseFolder.getAbsolutePath());
        }
    }
}

