/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.local;

import fm.last.moji.MojiFile;
import fm.last.moji.MojiFileAttributes;
import fm.last.moji.local.LocalFileNamingStrategy;
import fm.last.moji.local.LocalMojiFileAttributes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;

class LocalMojiFile
implements MojiFile {
    private final String domain;
    private final File baseDir;
    private String key;
    private final LocalFileNamingStrategy namingStrategy;
    private String storageClass;
    File file;

    LocalMojiFile(LocalFileNamingStrategy namingStrategy, File baseDir, String domain, String key, String storageClass) {
        this.namingStrategy = namingStrategy;
        this.baseDir = baseDir;
        this.key = key;
        this.domain = domain;
        this.storageClass = storageClass;
        this.file = new File(baseDir, namingStrategy.newFileName(domain, key, storageClass));
    }

    LocalMojiFile(LocalFileNamingStrategy namingStrategy, File baseFolder, String domain, String key) {
        this(namingStrategy, baseFolder, domain, key, "");
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public void delete() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        this.file.delete();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        return new FileOutputStream(this.file);
    }

    @Override
    public void copyToFile(File destination) throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        FileUtils.copyFile((File)this.file, (File)destination);
    }

    @Override
    public long length() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        return this.file.length();
    }

    @Override
    public void rename(String newKey) throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        File destination = new File(this.baseDir, this.namingStrategy.newFileName(this.domain, newKey, this.storageClass));
        this.file.renameTo(destination);
        this.file = destination;
        this.key = newKey;
    }

    @Override
    public List<URL> getPaths() throws IOException {
        return Collections.singletonList(this.file.toURI().toURL());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void modifyStorageClass(String newStorageClass) throws IOException {
        if (this.storageClass == null) {
            throw new IllegalArgumentException("storageClass == null");
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        this.file.renameTo(new File(this.baseDir, this.namingStrategy.newFileName(this.domain, this.key, newStorageClass)));
        this.storageClass = newStorageClass;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalMogileFile [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", file=");
        builder.append(this.file);
        builder.append(", storageClass=");
        builder.append(this.storageClass);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public MojiFileAttributes getAttributes() throws IOException {
        return new LocalMojiFileAttributes(this);
    }

    String getStorageClass() {
        return this.storageClass;
    }
}

