/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.local;

import fm.last.moji.MojiFileAttributes;
import fm.last.moji.local.LocalMojiFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

class LocalMojiFileAttributes
implements MojiFileAttributes {
    private final LocalMojiFile mojiFile;
    private final long length;
    private final List<URL> paths;

    public LocalMojiFileAttributes(LocalMojiFile mojiFile) throws IOException {
        this.mojiFile = mojiFile;
        this.length = mojiFile.length();
        this.paths = mojiFile.getPaths();
    }

    @Override
    public String getStorageClass() {
        return this.mojiFile.getStorageClass();
    }

    @Override
    public int getDeviceCount() {
        return this.paths.size();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getFid() {
        return 0L;
    }

    @Override
    public String getDomain() {
        return this.mojiFile.getDomain();
    }

    @Override
    public String getKey() {
        return this.mojiFile.getKey();
    }

    @Override
    public String getChecksum() {
        InputStream in = null;
        try {
            in = this.mojiFile.getInputStream();
            String string = String.format("MD5:%s", Hex.encodeHexString((byte[])DigestUtils.md5((InputStream)in)));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

