/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.spring;

import fm.last.moji.Moji;
import fm.last.moji.MojiDeviceStatus;
import fm.last.moji.MojiFile;
import fm.last.moji.impl.DefaultMojiFactory;
import fm.last.moji.impl.NetworkingConfiguration;
import fm.last.moji.tracker.impl.InetSocketAddressFactory;
import fm.last.moji.tracker.pool.MultiHostTrackerPool;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;

public class SpringMojiBean
implements Moji {
    private String addressesCsv;
    private String domain;
    private Moji moji;
    private MultiHostTrackerPool poolingTrackerFactory;
    private Proxy proxy = Proxy.NO_PROXY;
    private int httpConnectTimeout = 0;
    private int httpReadTimeout = 0;
    private int trackerReadTimeout = 0;
    private int trackerConnectTimeout = 0;
    private Boolean testOnReturn;
    private Boolean testOnBorrow;
    private Integer maxIdle;
    private Long maxWait;
    private Integer maxActive;

    public SpringMojiBean() {
    }

    @Deprecated
    public SpringMojiBean(String addressesCsv, String domain) {
        this(addressesCsv, Proxy.NO_PROXY, domain);
    }

    @Deprecated
    public SpringMojiBean(String addressesCsv, Proxy proxy, String domain) {
        this.addressesCsv = addressesCsv;
        this.proxy = proxy;
        this.domain = domain;
    }

    @PostConstruct
    public void initialise() {
        if (StringUtils.isBlank((String)this.addressesCsv)) {
            throw new IllegalStateException("addressesCsv not set");
        }
        if (StringUtils.isBlank((String)this.domain)) {
            throw new IllegalStateException("domain not set");
        }
        NetworkingConfiguration netConfig = this.createNetworkConfiguration();
        Set<InetSocketAddress> addresses = InetSocketAddressFactory.newAddresses(this.addressesCsv);
        this.createTrackerPool(netConfig, addresses);
        DefaultMojiFactory factory = new DefaultMojiFactory(this.poolingTrackerFactory, this.domain);
        this.moji = factory.getInstance();
    }

    @Override
    public MojiFile getFile(String key) {
        return this.moji.getFile(key);
    }

    @Override
    public MojiFile getFile(String key, String storageClass) {
        return this.moji.getFile(key, storageClass);
    }

    @Override
    public void copyToMogile(File source, MojiFile destination) throws IOException {
        this.moji.copyToMogile(source, destination);
    }

    @Override
    public List<MojiFile> list(String keyPrefix) throws IOException {
        return this.moji.list(keyPrefix);
    }

    @Override
    public List<MojiFile> list(String keyPrefix, int limit) throws IOException {
        return this.moji.list(keyPrefix, limit);
    }

    @Override
    public List<MojiDeviceStatus> getDeviceStatuses() throws IOException {
        return this.moji.getDeviceStatuses();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Set<InetSocketAddress> getAddresses() {
        return this.poolingTrackerFactory.getAddresses();
    }

    @PreDestroy
    public void close() throws Exception {
        this.poolingTrackerFactory.close();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public int getNumActive() {
        return this.poolingTrackerFactory.getNumActive();
    }

    public int getNumIdle() {
        return this.poolingTrackerFactory.getNumIdle();
    }

    public String getAddressesCsv() {
        return this.addressesCsv;
    }

    public void setAddressesCsv(String addressesCsv) {
        this.addressesCsv = addressesCsv;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getTrackerConnectTimeout() {
        return this.trackerConnectTimeout;
    }

    public void setTrackerConnectTimeout(int trackerConnectTimeout) {
        this.trackerConnectTimeout = trackerConnectTimeout;
    }

    public int getTrackerReadTimeout() {
        return this.trackerReadTimeout;
    }

    @Deprecated
    public void setTrackerSoTimeout(int trackerReadTimeout) {
        this.setTrackerReadTimeout(trackerReadTimeout);
    }

    public void setTrackerReadTimeout(int trackerReadTimeout) {
        this.trackerReadTimeout = trackerReadTimeout;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public void setHttpConnectTimeout(int httpConnectTimeout) {
        this.httpConnectTimeout = httpConnectTimeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    private NetworkingConfiguration createNetworkConfiguration() {
        return new NetworkingConfiguration.Builder().proxy(this.proxy).httpConnectTimeout(this.httpConnectTimeout).httpReadTimeout(this.httpReadTimeout).trackerConnectTimeout(this.trackerConnectTimeout).trackerReadTimeout(this.trackerReadTimeout).build();
    }

    private void createTrackerPool(NetworkingConfiguration netConfig, Set<InetSocketAddress> addresses) {
        this.poolingTrackerFactory = new MultiHostTrackerPool(addresses, netConfig);
        if (this.testOnBorrow != null) {
            this.poolingTrackerFactory.setTestOnBorrow(this.testOnBorrow);
        }
        if (this.testOnReturn != null) {
            this.poolingTrackerFactory.setTestOnReturn(this.testOnReturn);
        }
        if (this.maxActive != null) {
            this.poolingTrackerFactory.setMaxActive(this.maxActive);
        }
        if (this.maxIdle != null) {
            this.poolingTrackerFactory.setMaxIdle(this.maxIdle);
        }
        if (this.maxWait != null) {
            this.poolingTrackerFactory.setMaxWait(this.maxWait);
        }
    }
}

