/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.impl.NetworkingConfiguration;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.impl.RequestHandler;
import fm.last.moji.tracker.impl.TrackerImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTrackerFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractTrackerFactory.class);
    private final NetworkingConfiguration netConfig;

    @Deprecated
    public AbstractTrackerFactory(Proxy proxy) {
        this(new NetworkingConfiguration.Builder().proxy(proxy).build());
    }

    public AbstractTrackerFactory(NetworkingConfiguration netConfig) {
        this.netConfig = netConfig;
    }

    public Tracker newTracker(InetSocketAddress newAddress) throws TrackerException {
        log.debug("new {}()", (Object)TrackerImpl.class.getSimpleName());
        TrackerImpl tracker = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        Socket socket = null;
        try {
            socket = new Socket(this.netConfig.getProxy());
            socket.setSoTimeout(this.netConfig.getTrackerReadTimeout());
            log.debug("Connecting to: {}:", (Object)newAddress, (Object)socket.getPort());
            socket.connect(newAddress, this.netConfig.getTrackerConnectTimeout());
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            RequestHandler requestHandler = new RequestHandler(writer, reader);
            tracker = new TrackerImpl(socket, requestHandler);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly((Socket)socket);
            throw new TrackerException(e);
        }
        return tracker;
    }

    @Deprecated
    public Proxy getProxy() {
        return this.netConfig.getProxy();
    }

    public NetworkingConfiguration getNetworkingConfiguration() {
        return this.netConfig;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractTrackerFactory [networkingConfiguration=");
        builder.append(this.netConfig);
        builder.append("]");
        return builder.toString();
    }
}

