/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.Destination;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.UnknownStorageClassException;
import fm.last.moji.tracker.impl.ErrorCode;
import fm.last.moji.tracker.impl.Request;
import fm.last.moji.tracker.impl.RequestHandler;
import fm.last.moji.tracker.impl.Response;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CreateOpenOperation {
    private final String domain;
    private final String key;
    private final String storageClass;
    private final boolean multipleDestinations;
    private final RequestHandler requestHandler;
    private List<Destination> destinations;

    CreateOpenOperation(RequestHandler requestHandler, String domain, String key, String storageClass, boolean multipleDestinations) {
        this.requestHandler = requestHandler;
        this.domain = domain;
        this.key = key;
        this.storageClass = storageClass;
        this.multipleDestinations = multipleDestinations;
        this.destinations = Collections.emptyList();
    }

    public void execute() throws TrackerException {
        Request request = this.buildRequest();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            if (ErrorCode.UNKNOWN_CLASS.isContainedInLine(response.getMessage())) {
                throw new UnknownStorageClassException(this.storageClass);
            }
            if (!ErrorCode.UNKNOWN_KEY.isContainedInLine(response.getMessage())) {
                throw new TrackerException(response.getMessage());
            }
        } else {
            this.extractReturnValues(response);
        }
    }

    List<Destination> getDestinations() {
        return this.destinations;
    }

    private Request buildRequest() {
        Request.Builder builder = new Request.Builder(4).command("create_open").arg("domain", this.domain).arg("key", this.key).arg("multi_dest", this.multipleDestinations);
        if (this.storageClass != null && !this.storageClass.isEmpty()) {
            builder.arg("class", this.storageClass);
        }
        Request request = builder.build();
        return request;
    }

    private void extractReturnValues(Response response) throws TrackerException {
        long fid = Long.parseLong(response.getValue("fid"));
        int pathCount = Integer.parseInt(response.getValue("dev_count"));
        this.destinations = new ArrayList<Destination>(pathCount);
        for (int i = 1; i <= pathCount; ++i) {
            try {
                URL url = new URL(response.getValue("path_" + i));
                Integer devId = Integer.valueOf(response.getValue("devid_" + i));
                this.destinations.add(new Destination(url, devId, fid));
                continue;
            }
            catch (MalformedURLException e) {
                throw new TrackerException(e);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateOpenCommand [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", storageClass=");
        builder.append(this.storageClass);
        builder.append(", multipleDestinations=");
        builder.append(this.multipleDestinations);
        builder.append("]");
        return builder.toString();
    }
}

