/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.impl.Request;
import fm.last.moji.tracker.impl.RequestHandler;
import fm.last.moji.tracker.impl.Response;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetDeviceStatusesOperation {
    private static final Logger log = LoggerFactory.getLogger(GetDeviceStatusesOperation.class);
    private final RequestHandler requestHandler;
    private final String domain;
    private Map<String, Map<String, String>> parametersByDevice;

    GetDeviceStatusesOperation(RequestHandler requestHandler, String domain) {
        this.requestHandler = requestHandler;
        this.domain = domain;
        this.parametersByDevice = Collections.emptyMap();
    }

    public void execute() throws TrackerException {
        Request request = new Request.Builder(2).command("get_devices").arg("domain", this.domain).build();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            String message = response.getMessage();
            throw new TrackerException(message);
        }
        this.extractDeviceParameters(response);
    }

    Map<String, Map<String, String>> getParametersByDevice() {
        return Collections.unmodifiableMap(this.parametersByDevice);
    }

    private void extractDeviceParameters(Response response) {
        Map<String, String> valueMap = response.getValueMap();
        if (!valueMap.isEmpty()) {
            this.parametersByDevice = new HashMap<String, Map<String, String>>();
            for (Map.Entry<String, String> entry : valueMap.entrySet()) {
                String parameterName = entry.getKey().toLowerCase();
                boolean parameterAdded = false;
                if (!"devices".equalsIgnoreCase(parameterName)) {
                    int delimiterPosition = parameterName.indexOf(95);
                    if (parameterName.length() > 2 && delimiterPosition >= 0) {
                        String deviceName = parameterName.substring(0, delimiterPosition);
                        parameterName = parameterName.substring(delimiterPosition + 1);
                        Map<String, String> parameters = this.parametersByDevice.get(deviceName);
                        if (parameters == null) {
                            parameters = new HashMap<String, String>();
                            this.parametersByDevice.put(deviceName, parameters);
                        }
                        parameters.put(parameterName, entry.getValue());
                        parameterAdded = true;
                    }
                }
                if (parameterAdded) continue;
                log.debug("Ignoring parameter named: " + parameterName);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetDeviceStatusesOperation [domain=");
        builder.append(this.domain);
        builder.append(", parametersByDevice=");
        builder.append(this.parametersByDevice);
        builder.append("]");
        return builder.toString();
    }
}

