/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.UnknownKeyException;
import fm.last.moji.tracker.impl.ErrorCode;
import fm.last.moji.tracker.impl.Request;
import fm.last.moji.tracker.impl.RequestHandler;
import fm.last.moji.tracker.impl.Response;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GetPathsOperation {
    private final String domain;
    private final String key;
    private final boolean verify;
    private final RequestHandler requestHandler;
    private List<URL> paths;

    GetPathsOperation(RequestHandler requestHandler, String domain, String key, boolean verify) {
        this.domain = domain;
        this.key = key;
        this.verify = verify;
        this.requestHandler = requestHandler;
        this.paths = Collections.emptyList();
    }

    public void execute() throws TrackerException {
        Request request = new Request.Builder(3).command("get_paths").arg("domain", this.domain).arg("key", this.key).arg("noverify", !this.verify).build();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            if (ErrorCode.UNKNOWN_KEY.isContainedInLine(response.getMessage())) {
                throw new UnknownKeyException(this.domain, this.key);
            }
            throw new TrackerException(response.getMessage());
        }
        this.paths = this.extractReturnValue(response);
    }

    List<URL> getPaths() {
        return this.paths;
    }

    private List<URL> extractReturnValue(Response response) throws TrackerException {
        int pathCount = Integer.parseInt(response.getValue("paths"));
        ArrayList<URL> urls = new ArrayList<URL>(pathCount);
        for (int i = 1; i <= pathCount; ++i) {
            try {
                URL url = new URL(response.getValue("path" + i));
                urls.add(url);
                continue;
            }
            catch (MalformedURLException e) {
                throw new TrackerException(e);
            }
        }
        return urls;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetPathsCommand [domain=");
        builder.append(this.domain);
        builder.append(", key=");
        builder.append(this.key);
        builder.append(", verify=");
        builder.append(this.verify);
        builder.append("]");
        return builder.toString();
    }
}

