/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;

public class InetSocketAddressFactory {
    private InetSocketAddressFactory() {
    }

    public static Set<InetSocketAddress> newAddresses(String addressesCsv) {
        HashSet<String> addresses = new HashSet<String>();
        for (String addressElement : addressesCsv.split(",")) {
            addresses.add(addressElement.trim());
        }
        HashSet<InetSocketAddress> socketAddresses = new HashSet<InetSocketAddress>();
        for (String address : addresses) {
            InetSocketAddress socketAddress = InetSocketAddressFactory.newAddress(address);
            socketAddresses.add(socketAddress);
        }
        return socketAddresses;
    }

    public static InetSocketAddress newAddress(String addressString) {
        InetAddress address;
        String[] parts = addressString.split(":");
        String host = parts[0];
        int port = Integer.valueOf(parts[1]);
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid '<host>:<port>': '" + addressString + "'", e);
        }
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        return socketAddress;
    }
}

