/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.impl.ErrorCode;
import fm.last.moji.tracker.impl.Request;
import fm.last.moji.tracker.impl.RequestHandler;
import fm.last.moji.tracker.impl.Response;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ListKeysOperation {
    private final RequestHandler requestHandler;
    private final String domain;
    private final String keyPrefix;
    private final Integer limit;
    private List<String> keys;

    ListKeysOperation(RequestHandler requestHandler, String domain, String keyPrefix, Integer limit) {
        this.requestHandler = requestHandler;
        this.domain = domain;
        this.keyPrefix = keyPrefix;
        this.limit = limit;
        this.keys = Collections.emptyList();
    }

    void execute() throws TrackerException {
        Request request = this.buildRequest();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            if (!ErrorCode.NONE_MATCH.isContainedInLine(response.getMessage())) {
                throw new TrackerException(response.getMessage());
            }
        } else {
            this.keys = this.extractReturnValue(response);
        }
    }

    List<String> getKeys() {
        return this.keys;
    }

    private Request buildRequest() {
        Request.Builder builder = new Request.Builder(3).command("list_keys").arg("domain", this.domain).arg("prefix", this.keyPrefix);
        if (this.limit != null) {
            builder.arg("limit", this.limit);
        }
        Request request = builder.build();
        return request;
    }

    private List<String> extractReturnValue(Response response) {
        int keyCount = Integer.parseInt(response.getValue("key_count"));
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 1; i <= keyCount; ++i) {
            keys.add(response.getValue("key_" + i));
        }
        return keys;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ListKeysOperation [domain=");
        builder.append(this.domain);
        builder.append(", keyPrefix=");
        builder.append(this.keyPrefix);
        builder.append(", limit=");
        builder.append(this.limit);
        builder.append("]");
        return builder.toString();
    }
}

