/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.impl.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Request {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    private final String command;
    private final Map<String, String> arguments;

    private Request(Builder builder) {
        this.command = builder.command;
        this.arguments = builder.arguments;
    }

    String getCommand() {
        return this.command;
    }

    Map<String, String> getArguments() {
        return this.arguments;
    }

    void writeTo(Writer writer) throws IOException {
        StringBuilder wire = new StringBuilder();
        wire.append(this.command);
        wire.append(' ');
        boolean first = true;
        for (Map.Entry<String, String> entry : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                wire.append('&');
            }
            try {
                wire.append(URLEncoder.encode(entry.getKey(), Charsets.UTF_8.value()));
                wire.append('=');
                wire.append(URLEncoder.encode(entry.getValue(), Charsets.UTF_8.value()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        wire.append('\r');
        wire.append('\n');
        log.debug("Sent: {}", (Object)wire);
        writer.write(wire.toString());
        writer.flush();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Request [command=");
        builder.append(this.command);
        builder.append(", arguments=");
        builder.append(this.arguments);
        builder.append("]");
        return builder.toString();
    }

    static class Builder {
        private final Map<String, String> arguments;
        private String command;

        Builder(int expectedSize) {
            this.arguments = new LinkedHashMap<String, String>(expectedSize);
        }

        Builder command(String command) {
            this.command = command;
            return this;
        }

        Builder arg(String key, String value) {
            this.arguments.put(key, value);
            return this;
        }

        Builder arg(String key, int value) {
            this.arguments.put(key, Integer.toString(value));
            return this;
        }

        Builder arg(String key, long value) {
            this.arguments.put(key, Long.toString(value));
            return this;
        }

        Builder arg(String key, boolean value) {
            this.arguments.put(key, value ? "1" : "0");
            return this;
        }

        Builder arg(String key, URL value) {
            this.arguments.put(key, value.toString());
            return this;
        }

        Request build() {
            return new Request(this);
        }
    }
}

