/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.impl.CommunicationException;
import fm.last.moji.tracker.impl.Request;
import fm.last.moji.tracker.impl.Response;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private final Writer writer;
    private final BufferedReader reader;

    RequestHandler(Writer writer, BufferedReader reader) {
        this.writer = writer;
        this.reader = reader;
    }

    Response performRequest(Request request) throws CommunicationException {
        Response response = null;
        String line = null;
        try {
            log.debug("{}", (Object)request);
            request.writeTo(this.writer);
            line = this.reader.readLine();
            log.debug("Read: {}", (Object)line);
            response = this.createResponseFromLine(line);
            log.debug("{}", (Object)response);
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
        return response;
    }

    void close() {
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly((Writer)this.writer);
    }

    private Response createResponseFromLine(String line) throws TrackerException {
        if (line == null) {
            throw new TrackerException("Empty response from tracker");
        }
        int firstSpace = line.indexOf(32);
        if (firstSpace < 0) {
            throw new TrackerException("Invalid response from tracker: '" + line + "'");
        }
        ResponseStatus status = ResponseStatus.valueOfCode(line.substring(0, firstSpace));
        if (status == null) {
            throw new TrackerException("Invalid response from tracker: '" + line + "'");
        }
        String payload = line.substring(firstSpace + 1);
        Response response = new Response(status, payload);
        return response;
    }
}

