/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.impl.Charsets;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Response {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private final Map<String, String> values;
    private final ResponseStatus status;
    private final String message;

    Response(ResponseStatus status, String payload) {
        this.status = status;
        if (status == ResponseStatus.OK) {
            this.values = this.decodePayload(payload);
            this.message = null;
        } else {
            this.message = payload;
            this.values = Collections.emptyMap();
        }
    }

    ResponseStatus getStatus() {
        return this.status;
    }

    Map<String, String> getValueMap() {
        return this.values;
    }

    String getValue(String key) {
        return this.values.get(key);
    }

    String getMessage() {
        return this.message;
    }

    private Map<String, String> decodePayload(String encoded) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] parts;
            if (encoded == null || encoded.length() == 0) {
                return map;
            }
            for (String part : parts = encoded.split("&")) {
                String[] pair = part.split("=");
                if (pair.length != 2) {
                    log.error("Poorly encoded string: {} ", (Object)encoded);
                    continue;
                }
                map.put(pair[0], URLDecoder.decode(pair[1], Charsets.UTF_8.value()));
            }
            return Collections.unmodifiableMap(map);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Problem decoding response", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Response [status=");
        builder.append((Object)this.status);
        builder.append(", values=");
        builder.append(this.values);
        builder.append(", message=");
        builder.append(this.message);
        builder.append("]");
        return builder.toString();
    }
}

