/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.impl;

import fm.last.moji.tracker.Destination;
import fm.last.moji.tracker.KeyExistsAlreadyException;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.UnknownCommandException;
import fm.last.moji.tracker.UnknownKeyException;
import fm.last.moji.tracker.UnknownStorageClassException;
import fm.last.moji.tracker.impl.CreateOpenOperation;
import fm.last.moji.tracker.impl.ErrorCode;
import fm.last.moji.tracker.impl.GetDeviceStatusesOperation;
import fm.last.moji.tracker.impl.GetPathsOperation;
import fm.last.moji.tracker.impl.ListKeysOperation;
import fm.last.moji.tracker.impl.Request;
import fm.last.moji.tracker.impl.RequestHandler;
import fm.last.moji.tracker.impl.Response;
import fm.last.moji.tracker.impl.ResponseStatus;
import java.net.Socket;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrackerImpl
implements Tracker {
    private static final Logger log = LoggerFactory.getLogger(TrackerImpl.class);
    private final Socket socket;
    private final RequestHandler requestHandler;

    public TrackerImpl(Socket socket, RequestHandler requestHandler) {
        this.socket = socket;
        this.requestHandler = requestHandler;
    }

    @Override
    public List<URL> getPaths(String key, String domain) throws TrackerException {
        GetPathsOperation operation = new GetPathsOperation(this.requestHandler, domain, key, false);
        operation.execute();
        return operation.getPaths();
    }

    @Override
    public Map<String, String> fileInfo(String key, String domain) throws TrackerException {
        String command = "file_info";
        Request request = new Request.Builder(10).command(command).arg("domain", domain).arg("key", key).build();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            String message = response.getMessage();
            this.handleUnknownKeyException(key, domain, message);
            this.handleUnknownCommandException(command, message);
            throw new TrackerException(message);
        }
        return response.getValueMap();
    }

    @Override
    public List<Destination> createOpen(String key, String domain, String storageClass) throws TrackerException {
        CreateOpenOperation operation = new CreateOpenOperation(this.requestHandler, domain, key, storageClass, true);
        operation.execute();
        return operation.getDestinations();
    }

    @Override
    public List<String> list(String domain, String keyPrefix, Integer limit) throws TrackerException {
        ListKeysOperation operation = new ListKeysOperation(this.requestHandler, domain, keyPrefix, limit);
        operation.execute();
        return operation.getKeys();
    }

    @Override
    public void createClose(String key, String domain, Destination destination, long size) throws TrackerException {
        Request request = new Request.Builder(6).command("create_close").arg("domain", domain).arg("key", key).arg("devid", destination.getDevId()).arg("path", destination.getPath()).arg("fid", destination.getFid()).arg("size", size).build();
        Response response = this.requestHandler.performRequest(request);
        this.handleGeneralResponseError(response);
    }

    @Override
    public void delete(String key, String domain) throws TrackerException {
        Request request = new Request.Builder(2).command("delete").arg("domain", domain).arg("key", key).build();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            String message = response.getMessage();
            this.handleUnknownKeyException(key, domain, message);
            throw new TrackerException(message);
        }
    }

    @Override
    public void rename(String fromKey, String domain, String toKey) throws TrackerException {
        Request request = new Request.Builder(3).command("rename").arg("domain", domain).arg("from_key", fromKey).arg("to_key", toKey).build();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            String message = response.getMessage();
            this.handleUnknownKeyException(fromKey, domain, message);
            this.handleKeyAlreadyExists(domain, toKey, message);
            throw new TrackerException(message);
        }
    }

    @Override
    public void updateStorageClass(String key, String domain, String newStorageClass) throws TrackerException {
        Request request = new Request.Builder(3).command("updateclass").arg("domain", domain).arg("key", key).arg("class", newStorageClass).build();
        Response response = this.requestHandler.performRequest(request);
        if (response.getStatus() != ResponseStatus.OK) {
            String message = response.getMessage();
            this.handleUnknownKeyException(key, domain, message);
            this.handleUnknownStorageClass(newStorageClass, message);
            throw new TrackerException(message);
        }
    }

    @Override
    public Map<String, Map<String, String>> getDeviceStatuses(String domain) throws TrackerException {
        GetDeviceStatusesOperation operation = new GetDeviceStatusesOperation(this.requestHandler, domain);
        operation.execute();
        return operation.getParametersByDevice();
    }

    @Override
    public void noop() throws TrackerException {
        Request request = new Request.Builder(0).command("noop").build();
        Response response = this.requestHandler.performRequest(request);
        this.handleGeneralResponseError(response);
    }

    @Override
    public void close() {
        if (this.requestHandler != null) {
            this.requestHandler.close();
        }
        IOUtils.closeQuietly((Socket)this.socket);
        log.debug("Closed");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TrackerImpl [socket=");
        builder.append(this.socket);
        builder.append(", requestHandler=");
        builder.append(this.requestHandler);
        builder.append("]");
        return builder.toString();
    }

    private void handleUnknownStorageClass(String storageClass, String message) throws UnknownStorageClassException {
        if (ErrorCode.UNKNOWN_CLASS.isContainedInLine(message)) {
            throw new UnknownStorageClassException(storageClass);
        }
    }

    private void handleKeyAlreadyExists(String domain, String key, String message) throws KeyExistsAlreadyException {
        if (ErrorCode.KEY_EXISTS.isContainedInLine(message)) {
            throw new KeyExistsAlreadyException(domain, key);
        }
    }

    private void handleUnknownKeyException(String key, String domain, String message) throws UnknownKeyException {
        if (ErrorCode.UNKNOWN_KEY.isContainedInLine(message)) {
            throw new UnknownKeyException(domain, key);
        }
    }

    private void handleUnknownCommandException(String command, String message) throws UnknownCommandException {
        if (ErrorCode.UNKNOWN_COMMAND.isContainedInLine(message)) {
            throw new UnknownCommandException(command);
        }
    }

    private void handleGeneralResponseError(Response response) throws TrackerException {
        if (response.getStatus() != ResponseStatus.OK) {
            throw new TrackerException(response.getMessage());
        }
    }
}

