/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.pool;

import fm.last.moji.tracker.Destination;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.impl.CommunicationException;
import fm.last.moji.tracker.pool.ManagedTrackerHost;
import fm.last.moji.tracker.pool.MultiHostTrackerPool;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BorrowedTracker
implements Tracker {
    private static final Logger log = LoggerFactory.getLogger(BorrowedTracker.class);
    private final Tracker delegate;
    private final MultiHostTrackerPool pool;
    private final ManagedTrackerHost host;
    private CommunicationException lastException;

    BorrowedTracker(ManagedTrackerHost host, Tracker delegate, MultiHostTrackerPool pool) {
        this.delegate = delegate;
        this.host = host;
        this.pool = pool;
    }

    @Override
    public List<URL> getPaths(String key, String domain) throws TrackerException {
        List<URL> paths = Collections.emptyList();
        try {
            paths = this.delegate.getPaths(key, domain);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
        return paths;
    }

    @Override
    public Map<String, String> fileInfo(String key, String domain) throws TrackerException {
        Map<String, String> attributes = Collections.emptyMap();
        try {
            attributes = this.delegate.fileInfo(key, domain);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
        return attributes;
    }

    @Override
    public List<Destination> createOpen(String key, String domain, String storageClass) throws TrackerException {
        List<Destination> destinations = Collections.emptyList();
        try {
            destinations = this.delegate.createOpen(key, domain, storageClass);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
        return destinations;
    }

    @Override
    public void createClose(String key, String domain, Destination destination, long size) throws TrackerException {
        try {
            this.delegate.createClose(key, domain, destination, size);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
    }

    @Override
    public void delete(String key, String domain) throws TrackerException {
        try {
            this.delegate.delete(key, domain);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
    }

    @Override
    public void rename(String key, String domain, String newKey) throws TrackerException {
        try {
            this.delegate.rename(key, domain, newKey);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
    }

    @Override
    public void updateStorageClass(String key, String domain, String newStorageClass) throws TrackerException {
        try {
            this.delegate.updateStorageClass(key, domain, newStorageClass);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
    }

    @Override
    public void noop() throws TrackerException {
        try {
            this.delegate.noop();
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
    }

    @Override
    public List<String> list(String domain, String keyPrefix, Integer limit) throws TrackerException {
        List<String> keys = Collections.emptyList();
        try {
            keys = this.delegate.list(domain, keyPrefix, limit);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
        return keys;
    }

    @Override
    public Map<String, Map<String, String>> getDeviceStatuses(String domain) throws TrackerException {
        Map<String, Map<String, String>> parametersByDevice = Collections.emptyMap();
        try {
            parametersByDevice = this.delegate.getDeviceStatuses(domain);
            this.host.markSuccess();
        }
        catch (CommunicationException e) {
            this.lastException = e;
            throw e;
        }
        return parametersByDevice;
    }

    @Override
    public void close() {
        block6: {
            try {
                if (this.lastException != null) {
                    log.debug("Invalidating: {}", (Throwable)this.lastException);
                    try {
                        this.pool.invalidateTracker(this);
                        break block6;
                    }
                    finally {
                        this.delegate.close();
                    }
                }
                log.debug("Returning to pool");
                this.pool.returnTracker(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void reallyClose() {
        log.debug("Really closing");
        this.delegate.close();
    }

    CommunicationException getLastException() {
        return this.lastException;
    }

    ManagedTrackerHost getHost() {
        return this.host;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BorrowedTracker [host=");
        builder.append(this.host);
        builder.append(", lastException=");
        builder.append(this.lastException);
        builder.append(", delegate=");
        builder.append(this.delegate);
        builder.append(", pool=");
        builder.append(this.pool);
        builder.append("]");
        return builder.toString();
    }
}

