/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.pool;

import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.impl.AbstractTrackerFactory;
import fm.last.moji.tracker.pool.BorrowedTracker;
import fm.last.moji.tracker.pool.ManagedTrackerHost;
import fm.last.moji.tracker.pool.MultiHostTrackerPool;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BorrowedTrackerObjectPoolFactory
extends BaseKeyedPoolableObjectFactory<ManagedTrackerHost, BorrowedTracker> {
    private static final Logger log = LoggerFactory.getLogger(BorrowedTrackerObjectPoolFactory.class);
    private final AbstractTrackerFactory trackerFactory;
    private final MultiHostTrackerPool trackerPool;

    BorrowedTrackerObjectPoolFactory(AbstractTrackerFactory trackerFactory, MultiHostTrackerPool trackerPool) {
        this.trackerFactory = trackerFactory;
        this.trackerPool = trackerPool;
    }

    public BorrowedTracker makeObject(ManagedTrackerHost key) throws Exception {
        ManagedTrackerHost host = key;
        Tracker delegateTracker = this.trackerFactory.newTracker(host.getAddress());
        BorrowedTracker borrowedTracker = new BorrowedTracker(host, delegateTracker, this.trackerPool);
        log.debug("Requested new tracker instance: {}", (Object)key);
        return borrowedTracker;
    }

    public void destroyObject(ManagedTrackerHost key, BorrowedTracker value) throws Exception {
        BorrowedTracker borrowed = value;
        if (borrowed.getLastException() != null) {
            log.debug("Error occurred on tracker: {}", (Object)borrowed.getLastException().getMessage());
            borrowed.getHost().markAsFailed();
        }
        log.debug("Destroying {}", (Object)borrowed);
        borrowed.reallyClose();
    }

    public boolean validateObject(ManagedTrackerHost key, BorrowedTracker value) {
        BorrowedTracker borrowed = value;
        log.debug("Validating {}", (Object)borrowed);
        try {
            borrowed.noop();
        }
        catch (TrackerException e) {
            return false;
        }
        return true;
    }
}

