/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.pool;

import fm.last.commons.lang.time.Clock;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedTrackerHost {
    private static final Logger log = LoggerFactory.getLogger(ManagedTrackerHost.class);
    private final AtomicLong lastUsed = new AtomicLong();
    private final AtomicLong lastFailed = new AtomicLong();
    private final InetSocketAddress address;
    private int hostRetryInterval = 1;
    private TimeUnit hostRetryIntervalTimeUnit = TimeUnit.MINUTES;
    private final Timer resetTimer;
    private final Clock clock;
    private ResetTask resetTask;
    ResetTaskFactory resetTaskFactory;

    ManagedTrackerHost(InetSocketAddress address, Timer resetTimer, Clock clock) {
        this.resetTimer = resetTimer;
        this.resetTaskFactory = new ResetTaskFactory();
        this.clock = clock;
        this.address = address;
    }

    ManagedTrackerHost(InetSocketAddress address) {
        this(address, new Timer(true), Clock.INSTANCE);
    }

    void setHostRetryInterval(int interval, TimeUnit timeUnit) {
        this.hostRetryInterval = interval;
        this.hostRetryIntervalTimeUnit = timeUnit;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getLastUsedTime() {
        return this.formatTime(this.getLastUsed());
    }

    public String getLastFailedTime() {
        return this.formatTime(this.getLastFailed());
    }

    long getLastUsed() {
        return this.lastUsed.get();
    }

    long getLastFailed() {
        return this.lastFailed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsFailed() {
        this.lastFailed.set(this.clock.currentTimeMillis());
        Timer timer = this.resetTimer;
        synchronized (timer) {
            if (this.resetTask != null) {
                this.resetTask.cancel();
            }
            log.debug("Scheduling reset of {} in {} {}", new Object[]{this.address, this.hostRetryInterval, this.hostRetryIntervalTimeUnit.name().toLowerCase()});
            this.resetTask = this.resetTaskFactory.newInstance();
            this.resetTimer.schedule((TimerTask)this.resetTask, this.hostRetryIntervalTimeUnit.toMillis(this.hostRetryInterval));
        }
    }

    void markSuccess() {
        this.lastUsed.set(this.clock.currentTimeMillis());
        this.lastFailed.set(0L);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedTrackerHost)) {
            return false;
        }
        ManagedTrackerHost other = (ManagedTrackerHost)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ManagedTrackerAddress [address=");
        builder.append(this.address);
        builder.append(", lastUsed=");
        builder.append(this.formatTime(this.lastUsed.get()));
        builder.append(", lastFailed=");
        builder.append(this.formatTime(this.lastFailed.get()));
        builder.append("]");
        return builder.toString();
    }

    private String formatTime(long time) {
        if (time == 0L) {
            return "<never>";
        }
        return new Date(time).toString();
    }

    class ResetTaskFactory {
        ResetTaskFactory() {
        }

        public ResetTask newInstance() {
            return new ResetTask();
        }
    }

    class ResetTask
    extends TimerTask {
        ResetTask() {
        }

        @Override
        public void run() {
            ManagedTrackerHost.this.lastFailed.set(0L);
            log.debug("Reset failure monitor for {}", (Object)ManagedTrackerHost.this.address);
        }
    }
}

