/*
 * Decompiled with CFR 0.152.
 */
package fm.last.moji.tracker.pool;

import fm.last.moji.impl.NetworkingConfiguration;
import fm.last.moji.tracker.Tracker;
import fm.last.moji.tracker.TrackerException;
import fm.last.moji.tracker.TrackerFactory;
import fm.last.moji.tracker.impl.AbstractTrackerFactory;
import fm.last.moji.tracker.impl.CommunicationException;
import fm.last.moji.tracker.pool.BorrowedTracker;
import fm.last.moji.tracker.pool.BorrowedTrackerObjectPoolFactory;
import fm.last.moji.tracker.pool.HostPriorityOrder;
import fm.last.moji.tracker.pool.ManagedTrackerHost;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHostTrackerPool
implements TrackerFactory {
    private static final Logger log = LoggerFactory.getLogger(MultiHostTrackerPool.class);
    private final NetworkingConfiguration netConfig;
    private final GenericKeyedObjectPool<ManagedTrackerHost, BorrowedTracker> pool;
    private final List<ManagedTrackerHost> managedHosts;

    @Deprecated
    public MultiHostTrackerPool(Set<InetSocketAddress> addresses, Proxy proxy) {
        this(addresses, new NetworkingConfiguration.Builder().proxy(proxy).build());
    }

    public MultiHostTrackerPool(Set<InetSocketAddress> addresses, NetworkingConfiguration netConfig) {
        this.netConfig = netConfig;
        this.managedHosts = new ArrayList<ManagedTrackerHost>();
        for (InetSocketAddress address : addresses) {
            this.managedHosts.add(new ManagedTrackerHost(address));
        }
        AbstractTrackerFactory delegateTrackerFactory = new AbstractTrackerFactory(netConfig);
        BorrowedTrackerObjectPoolFactory objectFactory = new BorrowedTrackerObjectPoolFactory(delegateTrackerFactory, this);
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)objectFactory);
        log.debug("Pool created");
    }

    MultiHostTrackerPool(List<ManagedTrackerHost> managedHosts, NetworkingConfiguration netConfig, GenericKeyedObjectPool<ManagedTrackerHost, BorrowedTracker> pool) {
        this.managedHosts = managedHosts;
        this.netConfig = netConfig;
        this.pool = pool;
    }

    @Override
    public Tracker getTracker() throws TrackerException {
        ManagedTrackerHost managedHost = this.nextHost();
        Tracker tracker = null;
        try {
            tracker = (Tracker)this.pool.borrowObject((Object)managedHost);
        }
        catch (Exception e) {
            managedHost.markAsFailed();
            throw new CommunicationException(String.format("Unable connect to tracker %s", managedHost), e);
        }
        return tracker;
    }

    @Override
    public Set<InetSocketAddress> getAddresses() {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        for (ManagedTrackerHost host : this.managedHosts) {
            addresses.add(host.getAddress());
        }
        return Collections.unmodifiableSet(new HashSet(addresses));
    }

    @Override
    @Deprecated
    public Proxy getProxy() {
        return this.netConfig.getProxy();
    }

    @Override
    public NetworkingConfiguration getNetworkingConfiguration() {
        return this.netConfig;
    }

    public List<ManagedTrackerHost> getManagedHosts() {
        return this.managedHosts;
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    public long getMaxWait() {
        return this.pool.getMaxWait();
    }

    public void setMaxWait(long maxWait) {
        this.pool.setMaxWait(maxWait);
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public boolean getTestOnBorrow() {
        return this.pool.getTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.pool.setTestOnBorrow(testOnBorrow);
    }

    public boolean getTestOnReturn() {
        return this.pool.getTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.pool.setTestOnReturn(testOnReturn);
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    public void close() throws Exception {
        this.pool.close();
    }

    void invalidateTracker(BorrowedTracker borrowedTracker) throws Exception {
        this.pool.invalidateObject((Object)borrowedTracker.getHost(), (Object)borrowedTracker);
    }

    void returnTracker(BorrowedTracker borrowedTracker) throws Exception {
        this.pool.returnObject((Object)borrowedTracker.getHost(), (Object)borrowedTracker);
    }

    private ManagedTrackerHost nextHost() throws TrackerException {
        return Collections.max(this.managedHosts, HostPriorityOrder.INSTANCE);
    }
}

