/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage;

import java.io.File;
import scoverage.Constants;
import scoverage.Coverage;
import scoverage.report.CoberturaXmlWriter;
import scoverage.report.ScoverageHtmlWriter;
import scoverage.report.ScoverageXmlWriter;

public class ScoverageWriter {
    public static void write(File sourceDir, File reportDir, Coverage coverage, Boolean coverageOutputCobertura, Boolean coverageOutputXML, Boolean coverageOutputHTML, Boolean coverageDebug) {
        System.out.println("[scoverage] Generating scoverage reports...");
        reportDir.mkdirs();
        if (coverageOutputCobertura.booleanValue()) {
            new CoberturaXmlWriter(sourceDir, reportDir).write(coverage);
            System.out.println("[scoverage] Written Cobertura XML report to " + reportDir.getAbsolutePath() + File.separator + "cobertura.xml");
        }
        if (coverageOutputXML.booleanValue()) {
            new ScoverageXmlWriter(sourceDir, reportDir, false).write(coverage);
            System.out.println("[scoverage] Written XML report to " + reportDir.getAbsolutePath() + File.separator + Constants.XMLReportFilename());
            if (coverageDebug.booleanValue()) {
                new ScoverageXmlWriter(sourceDir, reportDir, true).write(coverage);
                System.out.println("[scoverage] Written XML report with debug information to " + reportDir.getAbsolutePath() + File.separator + Constants.XMLReportFilenameWithDebug());
            }
        }
        if (coverageOutputHTML.booleanValue()) {
            new ScoverageHtmlWriter(sourceDir, reportDir).write(coverage);
            System.out.println("[scoverage] Written HTML report to " + reportDir.getAbsolutePath() + File.separator + "index.html");
        }
        System.out.println("[scoverage] Coverage reports completed");
    }
}

