/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.IoUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

class Communicator
implements Closeable {
    private final Socket socket;
    private final BufferedReader in;
    private final BufferedWriter out;

    public Communicator(Socket socket, int timeout) throws IOException {
        socket.setSoTimeout(timeout);
        this.socket = socket;
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
        this.out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));
    }

    public int readLen() throws IOException {
        String line = this.in.readLine();
        return line == null ? 0 : Integer.parseInt(line);
    }

    public String readStatus() throws IOException {
        return this.in.readLine();
    }

    public String readContent(int len) throws IOException {
        char[] buf = new char[len];
        this.in.read(buf);
        return new String(buf);
    }

    public void writeStatus(String status) throws IOException {
        this.out.write(status);
        this.out.newLine();
    }

    public void writeLen(int len) throws IOException {
        this.out.write(Integer.toString(len));
        this.out.newLine();
        this.out.flush();
    }

    public void writeContent(String content) throws IOException {
        this.writeLen(content.length());
        this.out.write(content);
        this.out.newLine();
        this.out.flush();
    }

    @Override
    public void close() {
        IoUtils.closeQuietly(this.in);
        IoUtils.closeQuietly(this.out);
        IoUtils.closeQuietly(this.socket);
    }
}

