/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipResource
implements Resource {
    private final ZipFile jarFile;
    private final ZipEntry jarEntry;

    public ZipResource(ZipFile jarFile, ZipEntry jarEntry) {
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
    }

    @Override
    public String getPath() {
        return this.jarEntry.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.jarFile.getName() + "!/" + this.getPath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public String getClassName(String extension) {
        String path = this.getPath();
        return path.substring(0, path.length() - extension.length()).replace('/', '.');
    }
}

