/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojo.test;

import flash.util.StringUtils;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexUnitLauncher {
    private static final String[] WINDOWS_CMD = new String[]{"rundll32", "url.dll,FileProtocolHandler"};
    private static final String[] MAC_CMD = new String[]{"open", "-g"};
    private static final String[] UNIX_CMD = new String[]{"xdg-open"};
    private String[] launcherCommand = new String[0];
    private Log log;

    public FlexUnitLauncher() {
        this.launcherCommand = this.getPlatformDefaultCommand();
    }

    public FlexUnitLauncher(List<String> command, Log logger) {
        this.launcherCommand = command != null ? command.toArray(new String[0]) : this.getPlatformDefaultCommand();
        this.log = logger;
    }

    private String[] getPlatformDefaultCommand() {
        if (MavenUtils.isWindows()) {
            return WINDOWS_CMD;
        }
        if (MavenUtils.isMac()) {
            return MAC_CMD;
        }
        return UNIX_CMD;
    }

    public void runTests(File swf) throws Exception {
        if (this.launcherCommand != null) {
            this.launcherCommand = StringUtils.concat((String[])this.launcherCommand, (String[])new String[]{swf.getAbsolutePath()});
            this.log.debug((CharSequence)("exec: " + Arrays.asList(this.launcherCommand)));
            Commandline cl = new Commandline();
            cl.setExecutable(this.launcherCommand[0]);
            int i = 1;
            while (i < this.launcherCommand.length) {
                cl.createArg().setValue(this.launcherCommand[i]);
                ++i;
            }
            StreamConsumer stdout = new StreamConsumer(){

                public void consumeLine(String line) {
                    FlexUnitLauncher.this.log.debug((CharSequence)("[SYSOUT]: " + line));
                }
            };
            StreamConsumer stderr = new StreamConsumer(){

                public void consumeLine(String line) {
                    FlexUnitLauncher.this.log.debug((CharSequence)("[SYSERR]: " + line));
                }
            };
            this.log.debug((CharSequence)("commandline: " + cl));
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            this.log.debug((CharSequence)("result: " + result));
        } else if (MavenUtils.isWindows()) {
            Runtime.getRuntime().exec(StringUtils.concat((String[])WINDOWS_CMD, (String[])new String[]{swf.getAbsolutePath()}));
        } else if (MavenUtils.isMac()) {
            Runtime.getRuntime().exec(StringUtils.concat((String[])MAC_CMD, (String[])new String[]{swf.getAbsolutePath()}));
        } else {
            Process p = Runtime.getRuntime().exec(StringUtils.concat((String[])UNIX_CMD, (String[])new String[]{swf.getAbsolutePath()}));
            int exitValue = p.waitFor();
            if (exitValue != 0) {
                Runtime.getRuntime().exec(StringUtils.concat((String[])UNIX_CMD, (String[])new String[]{swf.getAbsolutePath()}));
            }
        }
    }
}

