/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableSet;
import io.airlift.http.client.AbstractHttpClientTest;
import io.airlift.http.client.ApacheHttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.TestingRequestFilter;
import java.util.Set;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ApacheHttpClientTest
extends AbstractHttpClientTest {
    private ApacheHttpClient httpClient;

    @BeforeMethod
    public void setUp() throws Exception {
        this.httpClient = new ApacheHttpClient(new HttpClientConfig(), (Set)ImmutableSet.of((Object)new TestingRequestFilter()));
    }

    @Override
    public <T, E extends Exception> T executeRequest(Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    @Override
    public <T, E extends Exception> T executeRequest(HttpClientConfig config, Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        try (ApacheHttpClient client = new ApacheHttpClient(config);){
            Object object = client.execute(request, responseHandler);
            return (T)object;
        }
    }

    @Override
    @Test(enabled=false, description="Apache sync client does not handle this correctly")
    public void testConnectReadRequestWriteJunkHangup() throws Exception {
        super.testConnectReadRequestWriteJunkHangup();
    }

    @Override
    @Test(enabled=false, description="This test takes forever")
    public void test100kGets() throws Exception {
        super.test100kGets();
    }
}

