/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public final class EchoServlet
extends HttpServlet {
    String requestMethod;
    URI requestUri;
    final ListMultimap<String, String> requestHeaders = ArrayListMultimap.create();
    int responseStatusCode = 200;
    String responseStatusMessage;
    final ListMultimap<String, String> responseHeaders = ArrayListMultimap.create();
    String responseBody;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestMethod = request.getMethod();
        this.requestUri = URI.create(HttpUtils.getRequestURL((HttpServletRequest)request).toString());
        if (request.getQueryString() != null) {
            this.requestUri = URI.create(this.requestUri.toASCIIString() + "?" + request.getQueryString());
        }
        this.requestHeaders.clear();
        for (String name : Collections.list(request.getHeaderNames())) {
            this.requestHeaders.putAll((Object)name, Collections.list(request.getHeaders(name)));
        }
        if (this.responseStatusMessage != null) {
            response.sendError(this.responseStatusCode, this.responseStatusMessage);
        } else {
            response.setStatus(this.responseStatusCode);
        }
        for (Map.Entry entry : this.responseHeaders.entries()) {
            response.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            if (request.getParameter("sleep") != null) {
                Thread.sleep(Long.parseLong(request.getParameter("sleep")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (request.getParameter("remotePort") != null) {
            response.addHeader("remotePort", String.valueOf(request.getRemotePort()));
        }
        if (this.responseBody != null) {
            response.getOutputStream().write(this.responseBody.getBytes(Charsets.UTF_8));
        }
    }
}

