/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import io.airlift.http.client.CacheControl;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCacheControl {
    @Test
    public void testFromSimpleString() {
        CacheControl c = CacheControl.valueOf((String)"public,must-revalidate");
        Assert.assertFalse((boolean)c.isPrivate());
        Assert.assertFalse((boolean)c.isNoStore());
        Assert.assertTrue((boolean)c.isMustRevalidate());
        Assert.assertFalse((boolean)c.isProxyRevalidate());
        Assert.assertFalse((boolean)c.isNoCache());
        Assert.assertFalse((boolean)c.isNoTransform());
        Assert.assertTrue((c.getNoCacheFields().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.getPrivateFields().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFromComplexString() {
        CacheControl c = CacheControl.valueOf((String)"private=\"foo\",no-cache=\"bar\",no-store,no-transform,must-revalidate,proxy-revalidate,max-age=2,s-maxage=3");
        Assert.assertTrue((boolean)c.isPrivate());
        Assert.assertTrue((boolean)c.isNoStore());
        Assert.assertTrue((boolean)c.isMustRevalidate());
        Assert.assertTrue((boolean)c.isProxyRevalidate());
        Assert.assertTrue((boolean)c.isNoCache());
        Assert.assertTrue((boolean)c.isNoTransform());
        Assert.assertTrue((c.getNoCacheFields().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((c.getPrivateFields().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)c.getPrivateFields().get(0)), (String)"foo");
        Assert.assertEquals((String)((String)c.getNoCacheFields().get(0)), (String)"bar");
    }

    @Test
    public void testToString() {
        String expected = "private=\"foo\",no-cache=\"bar\",no-store,no-transform,must-revalidate,proxy-revalidate,max-age=2,s-maxage=3";
        String parsed = CacheControl.valueOf((String)expected).toString();
        Assert.assertEquals((String)parsed, (String)expected);
    }

    @Test
    public void testNoCacheEnabled() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        Assert.assertEquals((String)cc.toString(), (String)"no-cache,no-transform");
    }

    @Test
    public void testNoCacheDisabled() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(false);
        Assert.assertEquals((String)cc.toString(), (String)"no-transform");
    }

    @Test
    public void testMultiplePrivateFields() {
        CacheControl cc = new CacheControl();
        cc.setPrivate(true);
        cc.getPrivateFields().add("a");
        cc.getPrivateFields().add("b");
        Assert.assertTrue((boolean)cc.toString().contains("private=\"a,b\""));
    }

    @Test
    public void testMultipleNoCacheFields() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.getNoCacheFields().add("c");
        cc.getNoCacheFields().add("d");
        Assert.assertTrue((boolean)cc.toString().contains("no-cache=\"c,d\""));
    }

    @Test
    public void testReadMultiplePrivateAndNoCacheFields() {
        String s = "private=\"foo1,foo2\",no-store,no-transform,must-revalidate,proxy-revalidate,max-age=2,s-maxage=3,no-cache=\"bar1,bar2\",ext=1";
        CacheControl cacheControl = CacheControl.valueOf((String)s);
        Assert.assertTrue((boolean)cacheControl.isPrivate());
        List privateFields = cacheControl.getPrivateFields();
        Assert.assertEquals((int)privateFields.size(), (int)2);
        Assert.assertEquals((String)((String)privateFields.get(0)), (String)"foo1");
        Assert.assertEquals((String)((String)privateFields.get(1)), (String)"foo2");
        Assert.assertTrue((boolean)cacheControl.isNoCache());
        List noCacheFields = cacheControl.getNoCacheFields();
        Assert.assertEquals((int)2, (int)noCacheFields.size());
        Assert.assertEquals((String)((String)noCacheFields.get(0)), (String)"bar1");
        Assert.assertEquals((String)((String)noCacheFields.get(1)), (String)"bar2");
        Assert.assertTrue((boolean)cacheControl.isNoStore());
        Assert.assertTrue((boolean)cacheControl.isNoTransform());
        Assert.assertTrue((boolean)cacheControl.isMustRevalidate());
        Assert.assertTrue((boolean)cacheControl.isProxyRevalidate());
        Assert.assertEquals((int)cacheControl.getMaxAge(), (int)2);
        Assert.assertEquals((int)cacheControl.getSMaxAge(), (int)3);
        Map cacheExtension = cacheControl.getCacheExtension();
        Assert.assertEquals((int)cacheExtension.size(), (int)1);
        Assert.assertEquals((String)((String)cacheExtension.get("ext")), (String)"1");
    }

    @Test
    public void testCacheExtensionToString() {
        CacheControl cc = new CacheControl();
        cc.getCacheExtension().put("ext1", null);
        cc.getCacheExtension().put("ext2", "value2");
        cc.getCacheExtension().put("ext3", "value 3");
        String value = cc.toString();
        Assert.assertTrue((value.contains("ext1") && !value.contains("ext1=") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)value.contains("ext2=value2"));
        Assert.assertTrue((boolean)value.contains("ext3=\"value 3\""));
    }
}

