/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.testng.annotations.Test;

public class TestHttpClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HttpClientConfig)ConfigAssertions.recordDefaults(HttpClientConfig.class)).setConnectTimeout(new Duration(1.0, TimeUnit.SECONDS)).setReadTimeout(new Duration(1.0, TimeUnit.MINUTES)).setKeepAliveInterval(null).setMaxConnections(200).setMaxConnectionsPerServer(20).setSocksProxy(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-client.connect-timeout", (Object)"4s").put((Object)"http-client.read-timeout", (Object)"5s").put((Object)"http-client.keep-alive-interval", (Object)"6s").put((Object)"http-client.max-connections", (Object)"12").put((Object)"http-client.max-connections-per-server", (Object)"3").put((Object)"http-client.socks-proxy", (Object)"localhost:1080").build();
        HttpClientConfig expected = new HttpClientConfig().setConnectTimeout(new Duration(4.0, TimeUnit.SECONDS)).setReadTimeout(new Duration(5.0, TimeUnit.SECONDS)).setKeepAliveInterval(new Duration(6.0, TimeUnit.SECONDS)).setMaxConnections(12).setMaxConnectionsPerServer(3).setSocksProxy(HostAndPort.fromParts((String)"localhost", (int)1080));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidations() {
        ValidationAssertions.assertFailsValidation((Object)new HttpClientConfig().setConnectTimeout(null), (String)"connectTimeout", (String)"may not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new HttpClientConfig().setReadTimeout(null), (String)"readTimeout", (String)"may not be null", NotNull.class);
    }
}

