/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableSet;
import io.airlift.http.client.AbstractHttpClientTest;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.NettyAsyncHttpClientConfig;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.TestingRequestFilter;
import io.airlift.http.client.netty.NettyAsyncHttpClient;
import java.util.Set;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestNettyHttpClient
extends AbstractHttpClientTest {
    private NettyAsyncHttpClient httpClient;

    @BeforeMethod
    public void setUp() throws Exception {
        this.httpClient = new NettyAsyncHttpClient("test", new HttpClientConfig(), new NettyAsyncHttpClientConfig(), (Set)ImmutableSet.of((Object)new TestingRequestFilter()));
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        this.httpClient.close();
    }

    @Override
    public <T, E extends Exception> T executeRequest(Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    @Override
    public <T, E extends Exception> T executeRequest(HttpClientConfig config, Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        try (NettyAsyncHttpClient client = new NettyAsyncHttpClient(config);){
            Object object = client.execute(request, responseHandler);
            return (T)object;
        }
    }

    @Override
    @Test(enabled=false, description="This Netty client does reuse connections")
    public void testKeepAlive() throws Exception {
        super.testKeepAlive();
    }
}

