/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import io.airlift.http.client.AbstractHttpClientTest;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.NettyAsyncHttpClientConfig;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.TestingRequestFilter;
import io.airlift.http.client.netty.NettyAsyncHttpClient;
import java.util.Set;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class TestPoolingNettyHttpsClient
extends AbstractHttpClientTest {
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private String originalTrustStore;
    private NettyAsyncHttpClient httpClient;

    TestPoolingNettyHttpsClient() {
        super("localhost", Resources.getResource((String)"localhost.keystore").toString());
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.originalTrustStore = System.getProperty(JAVAX_NET_SSL_TRUST_STORE);
        System.setProperty(JAVAX_NET_SSL_TRUST_STORE, Resources.getResource((String)"localhost.keystore").getPath());
        this.httpClient = new NettyAsyncHttpClient("test", new HttpClientConfig(), new NettyAsyncHttpClientConfig().setEnableConnectionPooling(true), (Set)ImmutableSet.of((Object)new TestingRequestFilter()));
    }

    @Override
    @AfterMethod
    public void tearDown() throws Exception {
        this.httpClient.close();
        if (this.originalTrustStore != null) {
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE, this.originalTrustStore);
        } else {
            System.clearProperty(JAVAX_NET_SSL_TRUST_STORE);
        }
    }

    @Override
    public <T, E extends Exception> T executeRequest(Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    @Override
    public <T, E extends Exception> T executeRequest(HttpClientConfig config, Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        try (NettyAsyncHttpClient client = new NettyAsyncHttpClient(config);){
            Object object = client.execute(request, responseHandler);
            return (T)object;
        }
    }
}

