/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.testing.EquivalenceTester;
import java.net.URI;
import org.testng.annotations.Test;

public class TestRequest {
    @Test
    public void testEquivalence() {
        BodyGenerator bodyGenerator = TestRequest.createBodyGenerator();
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new Request(this.createUri1(), "GET", this.createHeaders1(), null), (Object[])new Request[]{new Request(this.createUri1(), "GET", this.createHeaders1(), null)}).addEquivalentGroup((Object)new Request(this.createUri1(), "GET", this.createHeaders1(), bodyGenerator), (Object[])new Request[]{new Request(this.createUri1(), "GET", this.createHeaders1(), bodyGenerator)}).addEquivalentGroup((Object)new Request(this.createUri1(), "GET", this.createHeaders2(), bodyGenerator), (Object[])new Request[0]).addEquivalentGroup((Object)new Request(this.createUri2(), "GET", this.createHeaders1(), bodyGenerator), (Object[])new Request[0]).addEquivalentGroup((Object)new Request(this.createUri1(), "PUT", this.createHeaders1(), null), (Object[])new Request[]{new Request(this.createUri1(), "PUT", this.createHeaders1(), null)}).addEquivalentGroup((Object)new Request(this.createUri2(), "PUT", this.createHeaders1(), null), (Object[])new Request[0]).addEquivalentGroup((Object)new Request(this.createUri1(), "PUT", this.createHeaders2(), null), (Object[])new Request[0]).addEquivalentGroup((Object)new Request(this.createUri1(), "PUT", this.createHeaders1(), bodyGenerator), (Object[])new Request[]{new Request(this.createUri1(), "PUT", this.createHeaders1(), bodyGenerator)}).addEquivalentGroup((Object)new Request(this.createUri1(), "GET", this.createHeaders1(), TestRequest.createBodyGenerator()), (Object[])new Request[0]).addEquivalentGroup((Object)new Request(this.createUri1(), "PUT", this.createHeaders1(), TestRequest.createBodyGenerator()), (Object[])new Request[0]).check();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Cannot make requests to HTTP port 0")
    public void testCannotMakeRequestToIllegalPort() throws Exception {
        new Request(URI.create("http://example.com:0/"), "GET", this.createHeaders1(), TestRequest.createBodyGenerator());
    }

    private URI createUri1() {
        return URI.create("http://example.com");
    }

    private URI createUri2() {
        return URI.create("http://example.net");
    }

    private ListMultimap<String, String> createHeaders1() {
        return ImmutableListMultimap.of((Object)"foo", (Object)"bar", (Object)"abc", (Object)"xyz");
    }

    private ListMultimap<String, String> createHeaders2() {
        return ImmutableListMultimap.of((Object)"foo", (Object)"bar", (Object)"abc", (Object)"xyz", (Object)"qqq", (Object)"www", (Object)"foo", (Object)"zzz");
    }

    public static BodyGenerator createBodyGenerator() {
        return StaticBodyGenerator.createStaticBodyGenerator((byte[])new byte[0]);
    }
}

