/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableListMultimap;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.StaticBodyGenerator;
import java.net.URI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRequestBuilder {
    public static final BodyGenerator NULL_BODY_GENERATOR = StaticBodyGenerator.createStaticBodyGenerator((byte[])new byte[0]);

    @Test
    public void testRequestBuilder() {
        Request request = this.createRequest();
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((Object)request.getBodyGenerator(), (Object)NULL_BODY_GENERATOR);
        Assert.assertEquals((Object)request.getUri(), (Object)URI.create("http://example.com"));
        Assert.assertEquals((Object)request.getHeaders(), (Object)ImmutableListMultimap.of((Object)"newheader", (Object)"withvalue", (Object)"anotherheader", (Object)"anothervalue"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Cannot make requests to HTTP port 0")
    public void testCannotBuildRequestToIllegalPort() throws Exception {
        Request.Builder.prepareGet().setUri(URI.create("http://example.com:0/"));
    }

    @Test
    public void testBuilderFromRequest() {
        Request request = this.createRequest();
        Assert.assertEquals((Object)Request.Builder.fromRequest((Request)request).build(), (Object)request);
    }

    private Request createRequest() {
        return Request.Builder.prepareGet().setUri(URI.create("http://example.com")).addHeader("newheader", "withvalue").addHeader("anotherheader", "anothervalue").setBodyGenerator(NULL_BODY_GENERATOR).build();
    }
}

