/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.InMemoryEventClient;
import io.airlift.http.server.CurrentTimeMillisProvider;
import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.MockCurrentTimeMillisProvider;
import io.airlift.http.server.TimingFilter;
import io.airlift.tracetoken.TraceTokenManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDelimitedRequestLog {
    private File file;
    private DateTimeFormatter isoFormatter;

    @BeforeMethod
    public void setup() throws IOException {
        this.file = File.createTempFile(this.getClass().getName(), ".log");
        this.isoFormatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateHourMinuteSecondFraction()).appendTimeZoneOffset("Z", true, 2, 2).toFormatter();
    }

    @AfterMethod
    public void teardown() throws IOException {
        if (!this.file.delete()) {
            throw new IOException("Error deleting " + this.file.getAbsolutePath());
        }
    }

    @Test
    public void testWriteLog() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        long dispatchTime = 123L;
        long timeToFirstByte = 456L;
        long timeToLastByte = 3453L;
        long now = System.currentTimeMillis();
        long timestamp = now - 3453L;
        String user = "martin";
        String agent = "HttpClient 4.0";
        String referrer = "http://www.google.com";
        String ip = "4.4.4.4";
        String protocol = "protocol";
        String method = "GET";
        long requestSize = 5432L;
        String requestContentType = "request/type";
        long responseSize = 32311L;
        int responseCode = 200;
        String responseContentType = "response/type";
        HttpURI uri = new HttpURI("http://www.example.com/aaa+bbb/ccc?param=hello%20there&other=true");
        TraceTokenManager tokenManager = new TraceTokenManager();
        InMemoryEventClient eventClient = new InMemoryEventClient();
        MockCurrentTimeMillisProvider currentTimeMillisProvider = new MockCurrentTimeMillisProvider(timestamp + 3453L);
        DelimitedRequestLog logger = new DelimitedRequestLog(this.file.getAbsolutePath(), 1, tokenManager, (EventClient)eventClient, (CurrentTimeMillisProvider)currentTimeMillisProvider);
        Mockito.when((Object)principal.getName()).thenReturn((Object)"martin");
        Mockito.when((Object)request.getTimeStamp()).thenReturn((Object)timestamp);
        Mockito.when((Object)request.getDispatchTime()).thenReturn((Object)(timestamp + 123L));
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)"HttpClient 4.0");
        Mockito.when((Object)request.getHeader("Referer")).thenReturn((Object)"http://www.google.com");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"9.9.9.9");
        Mockito.when((Object)request.getHeaders("X-FORWARDED-FOR")).thenReturn(Collections.enumeration(ImmutableList.of((Object)"1.1.1.1, 2.2.2.2", (Object)"3.3.3.3, 4.4.4.4")));
        Mockito.when((Object)request.getProtocol()).thenReturn((Object)"unknown");
        Mockito.when((Object)request.getHeader("X-FORWARDED-PROTO")).thenReturn((Object)"protocol");
        Mockito.when((Object)request.getAttribute(TimingFilter.FIRST_BYTE_TIME)).thenReturn((Object)(timestamp + 456L));
        Mockito.when((Object)request.getUri()).thenReturn((Object)uri);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)principal);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getContentRead()).thenReturn((Object)5432L);
        Mockito.when((Object)request.getHeader("Content-Type")).thenReturn((Object)"request/type");
        Mockito.when((Object)response.getStatus()).thenReturn((Object)200);
        Mockito.when((Object)response.getContentCount()).thenReturn((Object)32311L);
        Mockito.when((Object)response.getHeader("Content-Type")).thenReturn((Object)"response/type");
        tokenManager.createAndRegisterNewRequestToken();
        logger.log(request, response);
        logger.stop();
        List events = eventClient.getEvents();
        Assert.assertEquals((int)events.size(), (int)1);
        HttpRequestEvent event = (HttpRequestEvent)events.get(0);
        Assert.assertEquals((long)event.getTimeStamp().getMillis(), (long)timestamp);
        Assert.assertEquals((String)event.getClientAddress(), (String)"4.4.4.4");
        Assert.assertEquals((String)event.getProtocol(), (String)"protocol");
        Assert.assertEquals((String)event.getMethod(), (String)"GET");
        Assert.assertEquals((String)event.getRequestUri(), (String)uri.toString());
        Assert.assertEquals((String)event.getUser(), (String)"martin");
        Assert.assertEquals((String)event.getAgent(), (String)"HttpClient 4.0");
        Assert.assertEquals((String)event.getReferrer(), (String)"http://www.google.com");
        Assert.assertEquals((long)event.getRequestSize(), (long)5432L);
        Assert.assertEquals((String)event.getRequestContentType(), (String)"request/type");
        Assert.assertEquals((long)event.getResponseSize(), (long)32311L);
        Assert.assertEquals((int)event.getResponseCode(), (int)200);
        Assert.assertEquals((String)event.getResponseContentType(), (String)"response/type");
        Assert.assertEquals((long)event.getTimeToDispatch(), (long)123L);
        Assert.assertEquals((Object)event.getTimeToFirstByte(), (Object)456L);
        Assert.assertEquals((long)event.getTimeToLastByte(), (long)3453L);
        Assert.assertEquals((String)event.getTraceToken(), (String)tokenManager.getCurrentRequestToken());
        String actual = Files.toString((File)this.file, (Charset)Charsets.UTF_8);
        String expected = String.format("%s\t%s\t%s\t%s\t%s\t%s\t%d\t%d\t%d\t%d\t%s\n", this.isoFormatter.print(timestamp), "4.4.4.4", "GET", uri, "martin", "HttpClient 4.0", 200, 5432L, 32311L, event.getTimeToLastByte(), tokenManager.getCurrentRequestToken());
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void testNoXForwardedProto() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        String protocol = "protocol";
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"protocol");
        InMemoryEventClient eventClient = new InMemoryEventClient();
        DelimitedRequestLog logger = new DelimitedRequestLog(this.file.getAbsolutePath(), 1, null, (EventClient)eventClient);
        logger.log(request, response);
        logger.stop();
        List events = eventClient.getEvents();
        Assert.assertEquals((int)events.size(), (int)1);
        HttpRequestEvent event = (HttpRequestEvent)events.get(0);
        Assert.assertEquals((String)event.getProtocol(), (String)"protocol");
    }

    @Test
    public void testNoTimeToFirstByte() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        InMemoryEventClient eventClient = new InMemoryEventClient();
        DelimitedRequestLog logger = new DelimitedRequestLog(this.file.getAbsolutePath(), 1, null, (EventClient)eventClient);
        logger.log(request, response);
        logger.stop();
        List events = eventClient.getEvents();
        Assert.assertEquals((int)events.size(), (int)1);
        HttpRequestEvent event = (HttpRequestEvent)events.get(0);
        Assert.assertNull((Object)event.getTimeToFirstByte());
    }

    @Test
    public void testNoXForwardedFor() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        String clientIp = "1.1.1.1";
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"1.1.1.1");
        InMemoryEventClient eventClient = new InMemoryEventClient();
        DelimitedRequestLog logger = new DelimitedRequestLog(this.file.getAbsolutePath(), 1, null, (EventClient)eventClient);
        logger.log(request, response);
        logger.stop();
        List events = eventClient.getEvents();
        Assert.assertEquals((int)events.size(), (int)1);
        HttpRequestEvent event = (HttpRequestEvent)events.get(0);
        Assert.assertEquals((String)event.getClientAddress(), (String)"1.1.1.1");
    }

    @Test
    public void testXForwardedForSkipPrivateAddresses() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = (Response)Mockito.mock(Response.class);
        String clientIp = "1.1.1.1";
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"9.9.9.9");
        Mockito.when((Object)request.getHeaders("X-FORWARDED-FOR")).thenReturn(Collections.enumeration(ImmutableList.of((Object)"1.1.1.1", (Object)"192.168.1.2, 172.16.0.1", (Object)"169.254.1.2, 127.1.2.3", (Object)"10.1.2.3")));
        InMemoryEventClient eventClient = new InMemoryEventClient();
        DelimitedRequestLog logger = new DelimitedRequestLog(this.file.getAbsolutePath(), 1, null, (EventClient)eventClient);
        logger.log(request, response);
        logger.stop();
        List events = eventClient.getEvents();
        Assert.assertEquals((int)events.size(), (int)1);
        HttpRequestEvent event = (HttpRequestEvent)events.get(0);
        Assert.assertEquals((String)event.getClientAddress(), (String)"1.1.1.1");
    }
}

