/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHttpServerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HttpServerConfig)ConfigAssertions.recordDefaults(HttpServerConfig.class)).setHttpEnabled(true).setHttpPort(8080).setHttpsEnabled(false).setHttpsPort(8443).setKeystorePath(null).setKeystorePassword(null).setLogPath("var/log/http-request.log").setLogRetentionTime(new Duration(15.0, TimeUnit.DAYS)).setMinThreads(2).setMaxThreads(200).setThreadMaxIdleTime(new Duration(1.0, TimeUnit.MINUTES)).setNetworkMaxIdleTime(new Duration(200.0, TimeUnit.SECONDS)).setUserAuthFile(null).setAdminEnabled(true).setAdminPort(0).setAdminMinThreads(2).setAdminMaxThreads(20).setMaxRequestHeaderSize(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-server.http.enabled", (Object)"false").put((Object)"http-server.http.port", (Object)"1").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.port", (Object)"2").put((Object)"http-server.https.keystore.path", (Object)"/keystore").put((Object)"http-server.https.keystore.key", (Object)"keystore password").put((Object)"http-server.log.path", (Object)"/log").put((Object)"http-server.log.retention-time", (Object)"1d").put((Object)"http-server.threads.min", (Object)"100").put((Object)"http-server.threads.max", (Object)"500").put((Object)"http-server.threads.max-idle-time", (Object)"10m").put((Object)"http-server.net.max-idle-time", (Object)"20m").put((Object)"http-server.auth.users-file", (Object)"/auth").put((Object)"http-server.admin.enabled", (Object)"false").put((Object)"http-server.admin.port", (Object)"3").put((Object)"http-server.admin.threads.min", (Object)"3").put((Object)"http-server.admin.threads.max", (Object)"4").put((Object)"http-server.max-request-header-size", (Object)"32kB").build();
        HttpServerConfig expected = new HttpServerConfig().setHttpEnabled(false).setHttpPort(1).setHttpsEnabled(true).setHttpsPort(2).setKeystorePath("/keystore").setKeystorePassword("keystore password").setLogPath("/log").setLogRetentionTime(new Duration(1.0, TimeUnit.DAYS)).setMinThreads(100).setMaxThreads(500).setThreadMaxIdleTime(new Duration(10.0, TimeUnit.MINUTES)).setNetworkMaxIdleTime(new Duration(20.0, TimeUnit.MINUTES)).setMaxRequestHeaderSize(new DataSize(32.0, DataSize.Unit.KILOBYTE)).setUserAuthFile("/auth").setAdminEnabled(false).setAdminPort(3).setAdminMinThreads(3).setAdminMaxThreads(4);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testDeprecatedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"http-server.http.enabled", (Object)"false").put((Object)"http-server.http.port", (Object)"1").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.port", (Object)"2").put((Object)"http-server.https.keystore.path", (Object)"/keystore").put((Object)"http-server.https.keystore.key", (Object)"keystore password").put((Object)"http-server.log.path", (Object)"/log").put((Object)"http-server.log.retention-time", (Object)"1d").put((Object)"http-server.threads.min", (Object)"100").put((Object)"http-server.threads.max", (Object)"500").put((Object)"http-server.threads.max-idle-time", (Object)"10m").put((Object)"http-server.net.max-idle-time", (Object)"20m").put((Object)"http-server.auth.users-file", (Object)"/auth").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"http-server.http.enabled", (Object)"false").put((Object)"http-server.http.port", (Object)"1").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.port", (Object)"2").put((Object)"http-server.https.keystore.path", (Object)"/keystore").put((Object)"http-server.https.keystore.password", (Object)"keystore password").put((Object)"http-server.log.path", (Object)"/log").put((Object)"http-server.log.retention-time", (Object)"1d").put((Object)"http-server.threads.min", (Object)"100").put((Object)"http-server.threads.max", (Object)"500").put((Object)"http-server.threads.max-idle-time", (Object)"10m").put((Object)"http-server.net.max-idle-time", (Object)"20m").put((Object)"http-server.auth.users-file", (Object)"/auth").build();
        ImmutableMap olderProperties = new ImmutableMap.Builder().put((Object)"jetty.http.enabled", (Object)"false").put((Object)"jetty.http.port", (Object)"1").put((Object)"jetty.https.enabled", (Object)"true").put((Object)"jetty.https.port", (Object)"2").put((Object)"jetty.https.keystore.path", (Object)"/keystore").put((Object)"jetty.https.keystore.password", (Object)"keystore password").put((Object)"jetty.log.path", (Object)"/log").put((Object)"jetty.log.retain-days", (Object)"1").put((Object)"jetty.threads.min", (Object)"100").put((Object)"jetty.threads.max", (Object)"500").put((Object)"jetty.threads.max-idle-time-ms", (Object)"600000").put((Object)"jetty.net.max-idle-time-ms", (Object)"1200000").put((Object)"jetty.auth.users-file", (Object)"/auth").build();
        ConfigAssertions.assertDeprecatedEquivalence(HttpServerConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties, olderProperties});
    }
}

