/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.event.client.EventModule;
import io.airlift.event.client.InMemoryEventClient;
import io.airlift.event.client.InMemoryEventModule;
import io.airlift.http.client.ApacheHttpClient;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.server.DummyFilter;
import io.airlift.http.server.DummyServlet;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpServerModule;
import io.airlift.http.server.TheServlet;
import io.airlift.node.NodeInfo;
import io.airlift.node.NodeModule;
import io.airlift.testing.FileUtils;
import io.airlift.tracetoken.TraceTokenModule;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestHttpServerModule {
    private File tempDir;

    @BeforeMethod
    public void setup() throws IOException {
        this.tempDir = Files.createTempDir().getCanonicalFile();
    }

    @AfterMethod
    public void tearDown() throws IOException {
        FileUtils.deleteRecursively((File)this.tempDir);
    }

    @Test
    public void testCanConstructServer() throws Exception {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node.environment", (Object)"test").put((Object)"http-server.http.port", (Object)"0").put((Object)"http-server.log.path", (Object)new File(this.tempDir, "http-request.log").getAbsolutePath()).build();
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)properties);
        Injector injector = Guice.createInjector((Module[])new Module[]{new HttpServerModule(), new NodeModule(), new ConfigurationModule(configFactory), new EventModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(DummyServlet.class);
            }
        }});
        HttpServer server = (HttpServer)injector.getInstance(HttpServer.class);
        Assert.assertNotNull((Object)server);
    }

    @Test
    public void testHttpServerUri() throws Exception {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node.environment", (Object)"test").put((Object)"http-server.http.port", (Object)"0").put((Object)"http-server.log.path", (Object)new File(this.tempDir, "http-request.log").getAbsolutePath()).build();
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)properties);
        Injector injector = Guice.createInjector((Module[])new Module[]{new HttpServerModule(), new NodeModule(), new ConfigurationModule(configFactory), new EventModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(DummyServlet.class);
            }
        }});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        HttpServer server = (HttpServer)injector.getInstance(HttpServer.class);
        Assert.assertNotNull((Object)server);
        server.start();
        try {
            HttpServerInfo httpServerInfo = (HttpServerInfo)injector.getInstance(HttpServerInfo.class);
            Assert.assertNotNull((Object)httpServerInfo);
            Assert.assertNotNull((Object)httpServerInfo.getHttpUri());
            Assert.assertEquals((String)httpServerInfo.getHttpUri().getScheme(), (String)"http");
            Assert.assertEquals((String)httpServerInfo.getHttpUri().getHost(), (String)nodeInfo.getInternalIp().getHostAddress());
            Assert.assertNull((Object)httpServerInfo.getHttpsUri());
        }
        catch (Exception e) {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServer() throws Exception {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node.environment", (Object)"test").put((Object)"http-server.http.port", (Object)"0").put((Object)"http-server.log.path", (Object)new File(this.tempDir, "http-request.log").getAbsolutePath()).build();
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)properties);
        Injector injector = Guice.createInjector((Module[])new Module[]{new HttpServerModule(), new NodeModule(), new ConfigurationModule(configFactory), new EventModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(DummyServlet.class);
                Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(DummyFilter.class).in(Scopes.SINGLETON);
                HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/", "webapp/user").withWelcomeFile("user-welcome.txt");
                HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/", "webapp/user2");
                HttpServerBinder.httpServerBinder((Binder)binder).bindResource("path", "webapp/user").withWelcomeFile("user-welcome.txt");
                HttpServerBinder.httpServerBinder((Binder)binder).bindResource("path", "webapp/user2");
            }
        }});
        HttpServerInfo httpServerInfo = (HttpServerInfo)injector.getInstance(HttpServerInfo.class);
        HttpServer server = (HttpServer)injector.getInstance(HttpServer.class);
        server.start();
        try {
            ApacheHttpClient client = new ApacheHttpClient();
            URI httpUri = httpServerInfo.getHttpUri();
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(httpUri).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(httpUri.resolve("/filter")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            Assert.assertEquals((int)response.getStatusCode(), (int)402);
            Assert.assertEquals((String)response.getStatusMessage(), (String)"filtered");
            this.assertResource(httpUri, (HttpClient)client, "", "welcome user!");
            this.assertResource(httpUri, (HttpClient)client, "user-welcome.txt", "welcome user!");
            this.assertResource(httpUri, (HttpClient)client, "user.txt", "user");
            this.assertResource(httpUri, (HttpClient)client, "user2.txt", "user2");
            this.assertResource(httpUri, (HttpClient)client, "path", "welcome user!");
            this.assertResource(httpUri, (HttpClient)client, "path/", "welcome user!");
            this.assertResource(httpUri, (HttpClient)client, "path/user-welcome.txt", "welcome user!");
            this.assertResource(httpUri, (HttpClient)client, "path/user.txt", "user");
            this.assertResource(httpUri, (HttpClient)client, "path/user2.txt", "user2");
        }
        finally {
            server.stop();
        }
    }

    private void assertResource(URI baseUri, HttpClient client, String path, String contents) {
        HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)baseUri);
        StringResponseHandler.StringResponse data = (StringResponseHandler.StringResponse)client.execute(Request.Builder.prepareGet().setUri(uriBuilder.appendPath(path).build()).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)data.getStatusCode(), (int)HttpStatus.OK.code());
        MediaType contentType = MediaType.parse((String)data.getHeader("Content-Type"));
        Assert.assertTrue((boolean)MediaType.PLAIN_TEXT_UTF_8.is(contentType), (String)("Expected text/plain but got " + contentType));
        Assert.assertEquals((String)data.getBody().trim(), (String)contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRequestEvent() throws Exception {
        long afterRequest;
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node.environment", (Object)"test").put((Object)"http-server.http.port", (Object)"0").put((Object)"http-server.log.path", (Object)new File(this.tempDir, "http-request.log").getAbsolutePath()).build();
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)properties);
        Injector injector = Guice.createInjector((Module[])new Module[]{new HttpServerModule(), new NodeModule(), new ConfigurationModule(configFactory), new InMemoryEventModule(), new TraceTokenModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(EchoServlet.class).in(Scopes.SINGLETON);
            }
        }});
        HttpServerInfo httpServerInfo = (HttpServerInfo)injector.getInstance(HttpServerInfo.class);
        InMemoryEventClient eventClient = (InMemoryEventClient)injector.getInstance(InMemoryEventClient.class);
        EchoServlet echoServlet = (EchoServlet)((Object)injector.getInstance(Key.get(Servlet.class, TheServlet.class)));
        HttpServer server = (HttpServer)injector.getInstance(HttpServer.class);
        server.start();
        URI requestUri = httpServerInfo.getHttpUri().resolve("/my/path");
        String userAgent = "my-user-agent";
        String referrer = "http://www.google.com";
        String token = "this is a trace token";
        String requestBody = Joiner.on((String)" ").join(Collections.nCopies(50, "request"));
        String requestContentType = "request/type";
        int responseCode = 555;
        String responseBody = Joiner.on((String)" ").join(Collections.nCopies(100, "response"));
        String responseContentType = "response/type";
        echoServlet.responseBody = responseBody;
        echoServlet.responseStatusCode = responseCode;
        echoServlet.responseHeaders.put((Object)"Content-Type", (Object)responseContentType);
        long beforeRequest = System.currentTimeMillis();
        try {
            ApacheHttpClient client = new ApacheHttpClient();
            StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)client.execute(Request.Builder.preparePost().setUri(requestUri).addHeader("User-Agent", userAgent).addHeader("Content-Type", requestContentType).addHeader("Referer", referrer).addHeader("X-Airlift-TraceToken", token).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)requestBody, (Charset)Charsets.UTF_8)).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler());
            afterRequest = System.currentTimeMillis();
            Assert.assertEquals((int)response.getStatusCode(), (int)responseCode);
            Assert.assertEquals((String)response.getBody(), (String)responseBody);
            Assert.assertEquals((String)response.getHeader("Content-Type"), (String)responseContentType);
        }
        finally {
            server.stop();
        }
        List events = eventClient.getEvents();
        Assert.assertEquals((int)events.size(), (int)1);
        HttpRequestEvent event = (HttpRequestEvent)events.get(0);
        Assert.assertEquals((String)event.getClientAddress(), (String)echoServlet.remoteAddress);
        Assert.assertEquals((String)event.getProtocol(), (String)"http");
        Assert.assertEquals((String)event.getMethod(), (String)"POST");
        Assert.assertEquals((String)event.getRequestUri(), (String)requestUri.getPath());
        Assert.assertNull((Object)event.getUser());
        Assert.assertEquals((String)event.getAgent(), (String)userAgent);
        Assert.assertEquals((String)event.getReferrer(), (String)referrer);
        Assert.assertEquals((String)event.getTraceToken(), (String)token);
        Assert.assertEquals((long)event.getRequestSize(), (long)requestBody.length());
        Assert.assertEquals((String)event.getRequestContentType(), (String)requestContentType);
        Assert.assertEquals((long)event.getResponseSize(), (long)responseBody.length());
        Assert.assertEquals((int)event.getResponseCode(), (int)responseCode);
        Assert.assertEquals((String)event.getResponseContentType(), (String)responseContentType);
        Assert.assertTrue((event.getTimeStamp().getMillis() >= beforeRequest ? 1 : 0) != 0);
        Assert.assertTrue((event.getTimeToLastByte() <= afterRequest - beforeRequest ? 1 : 0) != 0);
        Assert.assertNotNull((Object)event.getTimeToFirstByte());
        Assert.assertTrue((event.getTimeToDispatch() <= event.getTimeToFirstByte() ? 1 : 0) != 0);
        Assert.assertTrue((event.getTimeToFirstByte() <= event.getTimeToLastByte() ? 1 : 0) != 0);
    }

    private static final class EchoServlet
    extends HttpServlet {
        private int responseStatusCode = 300;
        private final ListMultimap<String, String> responseHeaders = ArrayListMultimap.create();
        public String responseBody;
        private String remoteAddress;

        private EchoServlet() {
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.remoteAddress = request.getRemoteAddr();
            for (Map.Entry entry : this.responseHeaders.entries()) {
                response.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            response.setStatus(this.responseStatusCode);
            if (this.responseBody != null) {
                response.getOutputStream().write(this.responseBody.getBytes(Charsets.UTF_8));
            }
        }
    }
}

