/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.airlift.event.client.EventClient;
import io.airlift.event.client.NullEventClient;
import io.airlift.http.client.ApacheHttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.server.DummyFilter;
import io.airlift.http.server.DummyServlet;
import io.airlift.http.server.HashLoginServiceProvider;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpServerProvider;
import io.airlift.http.server.RequestStats;
import io.airlift.node.NodeInfo;
import io.airlift.testing.FileUtils;
import io.airlift.tracetoken.TraceTokenManager;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jetty.security.LoginService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestHttpServerProvider {
    private HttpServer server;
    private File tempDir;
    private NodeInfo nodeInfo;
    private HttpServerConfig config;
    private HttpServerInfo httpServerInfo;

    @BeforeMethod
    public void setup() throws IOException {
        this.tempDir = Files.createTempDir().getCanonicalFile();
        this.config = new HttpServerConfig().setHttpPort(0).setLogPath(new File(this.tempDir, "http-request.log").getAbsolutePath());
        this.nodeInfo = new NodeInfo("test");
        this.httpServerInfo = new HttpServerInfo(this.config, this.nodeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    public void teardown() throws Exception {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        finally {
            FileUtils.deleteRecursively((File)this.tempDir);
        }
    }

    @Test
    public void testHttp() throws Exception {
        this.createServer();
        this.server.start();
        ApacheHttpClient client = new ApacheHttpClient();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(this.httpServerInfo.getHttpUri()).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
    }

    @Test
    public void testFilter() throws Exception {
        this.createServer();
        this.server.start();
        ApacheHttpClient client = new ApacheHttpClient();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(this.httpServerInfo.getHttpUri().resolve("/filter")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)402);
        Assert.assertEquals((String)response.getStatusMessage(), (String)"filtered");
    }

    @Test
    public void testHttpIsDisabled() throws Exception {
        this.config.setHttpEnabled(false);
        this.createServer();
        this.server.start();
        ApacheHttpClient client = new ApacheHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(2.0, TimeUnit.SECONDS)));
        try {
            StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)client.execute(Request.Builder.prepareGet().setUri(this.httpServerInfo.getHttpUri().resolve("/")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            if (response != null) {
                Assert.fail((String)("Expected connection refused, got response code: " + response.getStatusCode()));
            }
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ConnectException), (String)(e.getCause().getClass() + " instanceof ConnectException"));
        }
    }

    @Test
    public void testAuth() throws Exception {
        File file = File.createTempFile("auth", ".properties", this.tempDir);
        Files.write((CharSequence)"user: password", (File)file, (Charset)Charsets.UTF_8);
        this.config.setUserAuthFile(file.getAbsolutePath());
        this.createServer();
        this.server.start();
        ApacheHttpClient client = new ApacheHttpClient();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)client.execute(Request.Builder.prepareGet().setUri(this.httpServerInfo.getHttpUri()).addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])"user:password".getBytes()).trim()).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertEquals((String)response.getBody(), (String)"user");
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="insufficient threads configured for HTTP connector")
    public void testInsufficientThreadsHttp() throws Exception {
        this.config.setMaxThreads(1);
        this.createAndStartServer();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="insufficient threads configured for HTTPS connector")
    public void testInsufficientThreadsHttps() throws Exception {
        this.config.setHttpEnabled(false).setHttpsEnabled(true).setHttpsPort(0).setKeystorePath(Resources.getResource((String)"test.keystore").toString()).setKeystorePassword("airlift").setMaxThreads(1);
        this.createAndStartServer();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="insufficient threads configured for admin connector")
    public void testInsufficientThreadsAdmin() throws Exception {
        this.config.setAdminMaxThreads(1);
        this.createAndStartServer();
    }

    private void createAndStartServer() throws Exception {
        this.httpServerInfo = new HttpServerInfo(this.config, this.nodeInfo);
        this.createServer();
        this.server.start();
    }

    private void createServer() {
        HashLoginServiceProvider loginServiceProvider = new HashLoginServiceProvider(this.config);
        HttpServerProvider serverProvider = new HttpServerProvider(this.httpServerInfo, this.nodeInfo, this.config, (Servlet)new DummyServlet(), (Set)ImmutableSet.of((Object)new DummyFilter()), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), new RequestStats(), (EventClient)new NullEventClient());
        serverProvider.setTheAdminServlet((Servlet)new DummyServlet());
        serverProvider.setLoginService((LoginService)loginServiceProvider.get());
        serverProvider.setTokenManager(new TraceTokenManager());
        this.server = serverProvider.get();
    }
}

